jQuery(document).ready(function ($) {
    // Function to validate the city
    function validateCity(city, stateCode, callback) {
        $.ajax({
            url: 'https://demogdi.itrekdesigns.website/api/v1/validate-city/' + stateCode + '/' + city,
            success: function (response) {
                callback(response.valid);
            },
            error: function () {
                console.error('Error: Unable to validate city');
                callback(false); // Treat as invalid if an error occurs
            }
        });
    }

    // Add custom validation logic here
    $('#billing_city').on('blur', function () {
        var city = $(this).val();
        var stateCode = $('#billing_state').val(); // Assuming the state code is stored in an input with id "billing_state"
        validateCity(city, stateCode, function (isValid) {
            if (!isValid) {
                // Log an error message to the console
                console.error('Error: City is not valid');
                // Find the <ul> element with class "woocommerce-error" and append the error message
                $('.woocommerce-error').append('<li><b>' + city + '</b> not found in the specified Province</li>');
            } else {
                // Remove the error message if the city is valid
                $('.woocommerce-error li:contains("Please enter a valid city.")').remove();
            }
        });
    });

    // Attach an event handler to the form submission
    $('form.checkout').on('submit', function (e) {
        var city = $('#billing_city').val();
        var stateCode = $('#billing_state').val();

        // Validate the city before submitting the form
        validateCity(city, stateCode, function (isValid) {
            if (!isValid) {
                // City is invalid, prevent form submission
                e.preventDefault();
                console.error('Error: City is not valid');
                $('.woocommerce-error').append('<li><b>' + city + '</b> not found in the specified Province</li>');
            }
        });
    });
});
