<?php
/*
Plugin Name: Custom Cart URL
Description: Adds a shortcode to output the cart URL with a sellerid parameter from the URL.
Version: 1.1
Author: iTREKDesigns
*/

function custom_cart_url_shortcode() {
    // Retrieve 'sellerid' parameter from the current URL and sanitize it
    $seller_id = isset($_GET['sellerid']) ? sanitize_text_field($_GET['sellerid']) : '2'; // Default to 1 if not set

    // Create the cart URL with the sellerid parameter
    $cart_url = esc_url(site_url('/cart/?sellerid=' . $seller_id));

    // Return only the URL
    return $cart_url;
}

// Register the shortcode [cart_url]
add_shortcode('cart_url', 'custom_cart_url_shortcode');
