<?php

/* SCRIPTS & CSS */

// add_action('wp_enqueue_scripts', 'enqueue_location_script');
// function enqueue_location_script() {
//     if (is_checkout()) {
//         wp_enqueue_script('province_city_barangay_dropdown', get_site_url() . '/gdi/js/province_city_barangay_dropdown.js', ['jquery'], '1.0', true);
//         wp_localize_script('province_city_barangay_dropdown', 'locationData', [
//             'jsonUrl' => get_site_url() . '/gdi/json/province_city_barangay.json'
//         ]);
//     }
// }

add_action('wp_enqueue_scripts', function () {
  if (is_checkout()) {
    wp_enqueue_script(
      'province_city_barangay_dropdown',
      get_site_url() . '/gdi/js/province_city_barangay_dropdown.js',
      ['jquery', 'wc-checkout'],
      time(), // dev cache-bust; replace with filemtime() in prod
      true
    );
    wp_localize_script('province_city_barangay_dropdown', 'locationData', [
      'jsonUrl' => get_site_url() . '/gdi/json/province_city_barangay.json'
    ]);
  }
});

// Show "Select a province" in the Province field without changing its style
add_filter('woocommerce_checkout_fields', function ($fields) {
    if (isset($fields['billing']['billing_state'])) {
        $fields['billing']['billing_state']['label'] = 'Province';
        $fields['billing']['billing_state']['placeholder'] = 'Select a province';
        $fields['billing']['billing_state']['custom_attributes']['data-placeholder'] = 'Select a province'; // Select2
        $fields['billing']['billing_state']['default'] = ''; // keep blank
    }
    return $fields;
}, 8);


add_filter('woocommerce_checkout_get_value', function ($value, $input) {
    if ($input === 'billing_state') {
        // return '' to always start blank, or return a forced value
        return '';
    }
    return $value;
}, 10, 2);

add_filter('default_checkout_billing_country', fn() => 'PH');

// Remove "Ship to a different address?" toggle
add_filter( 'woocommerce_cart_needs_shipping_address', '__return_false' );

// Remove order notes field
add_filter( 'woocommerce_enable_order_notes_field', '__return_false' );


add_filter('woocommerce_checkout_fields', 'modify_billing_fields');

function modify_billing_fields($fields) {
    // Change billing_city to a dropdown
    $fields['billing']['billing_city'] = [
        'type'        => 'select',
        'label'       => __('City/Municipality'),
        'required'    => true,
        'options'     => ['' => 'Select a city/municipality']
    ];

    // Change billing_address_1 to a dropdown
    $fields['billing']['billing_address_1'] = [
        'type'        => 'select',
        'label'       => __('Barangay'),
        'required'    => true,
        'options'     => ['' => 'Select a barangay']
    ];

    return $fields;
}


// Function to append sellerid parameter to links
function append_seller_id_to_links($content) {
    // Get the current seller ID from the URL
    $seller_id = isset($_GET['sellerid']) ? sanitize_text_field($_GET['sellerid']) : '';

    // Check if seller ID exists and is numeric
    if (!empty($seller_id) && is_numeric($seller_id)) {
        // Append sellerid parameter to all links in the content
        $content = preg_replace_callback('/<a\s+(?:[^>]*?\s+)?href=([\'"])(.*?)\1/i', function($matches) use ($seller_id) {
            $url = $matches[2];
            // Check if the link already has parameters
            if (strpos($url, '?') !== false) {
                $url .= '&sellerid=' . urlencode($seller_id);
            } else {
                $url .= '?sellerid=' . urlencode($seller_id);
            }
            return '<a href="' . esc_url($url) . '"';
        }, $content);
        
        // Append sellerid parameter to home URL in the content
        $home_url = esc_url(home_url());
        if (strpos($home_url, '?') !== false) {
            $home_url .= '&sellerid=' . urlencode($seller_id);
        } else {
            $home_url .= '?sellerid=' . urlencode($seller_id);
        }
        $content = str_replace('href="' . esc_url(home_url()) . '"', 'href="' . $home_url . '"', $content);
    }

    return $content;
}

// Apply the function to the_content filter
add_filter('the_content', 'append_seller_id_to_links');


// Modify cart page link to include seller ID parameter
function modify_cart_page_link()
{
	$sellerid = isset($_GET['sellerid']) ? sanitize_text_field($_GET['sellerid']) : '2';
	$checkout_url = esc_url(wc_get_checkout_url()) . '?sellerid=' . urlencode($sellerid);
	echo '<a href="' . $checkout_url . '" class="button">Proceed to Checkout</a>';
}
remove_action('woocommerce_proceed_to_checkout', 'woocommerce_button_proceed_to_checkout', 20);
add_action('woocommerce_proceed_to_checkout', 'modify_cart_page_link');

// Modify View Cart button
function modify_view_cart_button($button_url)
{
	// Get the current seller ID or set a default value
	$seller_id = isset($_GET['sellerid']) ? sanitize_text_field($_GET['sellerid']) : '2';

	// Append the seller ID parameter to the view cart URL
	$view_cart_url = add_query_arg('sellerid', $seller_id, $button_url);

	return $view_cart_url;
}

// Apply the modification to the view cart button
add_filter('woocommerce_get_cart_url', 'modify_view_cart_button');

//Automatically appends sellerid to the "Return to Shop" button in both Cart & Checkout pages.
function modify_return_to_shop_url($return_url) {
    // Get the current seller ID from the URL or set a default value
    $seller_id = isset($_GET['sellerid']) ? sanitize_text_field($_GET['sellerid']) : '2';

    // Append sellerid to the "Return to Shop" button link
    $return_url = add_query_arg('sellerid', $seller_id, $return_url);

    return esc_url($return_url);
}
add_filter('woocommerce_return_to_shop_redirect', 'modify_return_to_shop_url');



// Exclude specific checkout field from being remembered and populated
add_filter('woocommerce_checkout_get_value', 'exclude_specific_checkout_field', 10, 2);
function exclude_specific_checkout_field($value, $input)
{
	// Specify the field ID to exclude from being remembered
	if ($input === 'billing_seller_id') {
		// Fetch the seller ID from the URL parameter
		$seller_id = isset($_GET['sellerid']) ? sanitize_text_field($_GET['sellerid']) : '';
		// Return the seller ID value or an empty string
		return $seller_id;
	}
	return $value;
}

//Add the "Seller ID" field to the checkout page and set its value from the URL parameter
function custom_checkout_fields($fields)
{

	// Fetch the seller ID from the URL parameter
	$seller_id = isset($_GET['sellerid']) ? sanitize_text_field($_GET['sellerid']) : '';

	// Add a new field for Seller ID and set its value
	$fields['billing']['billing_seller_id'] = array(
		'label' => __('Seller ID', 'woocommerce'),
		'required' => true,
		'class' => array('form-row-wide'),
		'value' => $seller_id,
		'type' => 'hidden',
	);

	return $fields;
}
add_filter('woocommerce_checkout_fields', 'custom_checkout_fields');

// Validate Seller ID before order placement
function validate_seller_id()
{
    if (!isset($_POST['billing_seller_id']) || !is_numeric($_POST['billing_seller_id']) || $_POST['billing_seller_id'] < 2) {
        wc_add_notice(__('Invalid seller link, please ask the correct link to your seller.'), 'error');
    }
}
add_action('woocommerce_checkout_process', 'validate_seller_id');



// Save seller ID when an order is created
function save_sellerid_in_order_meta($order_id) {
    if (isset($_GET['sellerid']) && is_numeric($_GET['sellerid']) && $_GET['sellerid'] >= 2) {
        update_post_meta($order_id, '_seller_id', sanitize_text_field($_GET['sellerid']));
    }
}
add_action('woocommerce_checkout_create_order', 'save_sellerid_in_order_meta');


// Append sellerid to order received page URL
function add_sellerid_to_order_received_url($order_received_url, $order) {
    // Retrieve the seller ID from the order metadata
    $seller_id = get_post_meta($order->get_id(), '_seller_id', true);

    // Append the seller ID if it exists and is valid
    if (!empty($seller_id) && is_numeric($seller_id) && $seller_id >= 2) {
        $order_received_url = add_query_arg('sellerid', $seller_id, $order_received_url);
    }

    return $order_received_url;
}
add_filter('woocommerce_get_checkout_order_received_url', 'add_sellerid_to_order_received_url', 10, 2);





function setting_checkout_fields($fields)
{
	// Modify labels and priorities for existing fields
	$fields['billing']['billing_address_1']['priority'] = 23;
	$fields['billing']['billing_address_1']['label'] = 'Barangay';
	$fields['billing']['billing_city']['priority'] = 22;
	$fields['billing']['billing_city']['label'] = 'Municipality / City';
	$fields['billing']['billing_state']['priority'] = 20;
	$fields['billing']['billing_state']['label'] = 'Province';
	$fields['billing']['billing_address_2'] = array(
		'label' => __('Street Name, Building, House No.', 'woocommerce'),
		'required' => true,
		'class' => array('form-row-wide'),
		'priority' => 24, // Set priority greater than the "Municipality / City" field
	);

	return $fields;
}
add_filter('woocommerce_checkout_fields', 'setting_checkout_fields');

// Prevent order placement if there are validation errors
add_action('woocommerce_checkout_before_order_review', 'check_validation_errors');

function check_validation_errors()
{
	if (wc_notice_count('error') > 0) {
		remove_action('woocommerce_checkout_order_processed', 'wc_clear_notices', 10);
		wc_add_notice(__('Please correct the errors before placing your order.'), 'error');
	}
}


function remove_company_field($fields)
{
	unset($fields['billing']['billing_company']);
	unset($fields['billing']['billing_postcode']);
	unset($fields['shipping']);
	unset($fields['company']);
	unset($fields['postcode']);

	return $fields;
}
add_filter('woocommerce_checkout_fields', 'remove_company_field');

function hide_country_field($fields)
{
	$fields['country']['label'] = '';
	$fields['country']['type'] = 'hidden';

	return $fields;
}
add_filter('woocommerce_default_address_fields', 'hide_country_field');


function disable_author_archive() {
    if (is_author()) {
        wp_redirect(home_url(), 301);
        exit;
    }
}
add_action('template_redirect', 'disable_author_archive');

function get_sellerid_link($atts) {
    $atts = shortcode_atts(
        ['page' => ''], // Default to an empty page if not provided
        $atts,
        'sellerid_link'
    );

    $sellerid = isset($_GET['sellerid']) ? esc_attr($_GET['sellerid']) : '2';

    // Generate the full URL with the seller ID
    $url = site_url($atts['page'] . '/?sellerid=' . $sellerid);

    return esc_url($url);
}
add_shortcode('sellerid_link', 'get_sellerid_link');




/**
 * uicore functions and definitions
 *
 * @link https://developer.wordpress.org/themes/basics/theme-functions/
 *
 * @package uicore-theme
 */
defined('ABSPATH') || exit;

//Global Constants
define('UICORE_THEME_VERSION', '4.0.0');
define('UICORE_THEME_NAME', 'Affirm');
define('UICORE_FRAMEWORK_VERSION', '6.0.0');

$uicore_includes = array(
	'/setup.php',
	'/default.php',
	'/template-tags.php',
	'/plugin-activation.php'
);

foreach ($uicore_includes as $file) {
	require_once get_template_directory() . '/inc' . $file;
}

//Required
if ( ! isset( $content_width ) ) {
	$content_width = 1000;
}
if ( is_singular() && !class_exists('\UiCore\Core')) {
	wp_enqueue_script( "comment-reply" );
}


//disable element pack self update
function uicore_disable_plugin_updates( $value ) {

    $pluginsToDisable = [
        'bdthemes-element-pack/bdthemes-element-pack.php',
        'metform-pro/metform-pro.php'
    ];

    if ( isset($value) && is_object($value) ) {
        foreach ($pluginsToDisable as $plugin) {
            if ( isset( $value->response[$plugin] ) ) {
                unset( $value->response[$plugin] );
            }
        }
    }
    return $value;
}
add_filter( 'site_transient_update_plugins', 'uicore_disable_plugin_updates' );
