@extends('backend.layouts.app')

@section('content')
    <div class="card">
        <form action="{{ route('admin.commission_log.index') }}" method="GET">
            <div class="card-header row gutters-5">
                <div class="col text-center text-md-left">
                    <h5 class="mb-md-0 h6">{{ translate('Earning History') }}</h5>
                </div>
                <div class="col-md-3 ml-auto">
                    <select id="demo-ease" class="form-control aiz-selectpicker mb-2 mb-md-0" name="user_id"
                        data-selected="{{ $user_id }}">
                        <option value="">{{ translate('Choose Seller') }}</option>
                        @foreach (\App\Models\User::where('user_type', 'seller')->get() as $user)
                            <option value="{{ $user->id }}" {{ $user_id == $user->id ? 'selected' : '' }}>
                                {{ $user->name }}
                            </option>
                        @endforeach
                    </select>
                </div>

                <div class="col-md-3">
                    <div class="form-group mb-0">
                        <input type="text" class="form-control aiz-date-range" id="search"
                            name="date_range"value="{{ $date_range }}" placeholder="{{ translate('Daterange') }}">
                    </div>
                </div>
                <div class="col-md-auto">
                    <button class="btn btn-primary" type="submit">
                        {{ translate('Filter') }}
                    </button>
                </div>
            </div>
        </form>
        <div class="card-body">

            <table class="table aiz-table mb-0">
                <thead>
                    <tr>
                        <th>#</th>
                        <th data-breakpoints="lg">{{ translate('Seller') }}</th>
                        <th data-breakpoints="lg">{{ translate('Source') }}</th>
                        <th>{{ translate('Seller Earning') }}</th>
                        <th data-breakpoints="lg">{{ translate('Calculated At') }}</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach ($commission_history as $key => $history)
                        <tr>
                            <td>{{ $key + 1 }}</td>
                            <td>{{ $history->user->name ?? 'User Unavailable' }}</td>
                            <td>
                                {{ $history->details ?? 'Order Unavailable' }}
                            </td>
                            <td>{{ format_price($history->seller_earning) }}</td>
                            <td>{{ $history->created_at }}</td>
                        </tr>
                    @endforeach
                </tbody>
            </table>
            <div class="aiz-pagination mt-4">
                {{ $commission_history->links() }}
            </div>
        </div>
    </div>
@endsection

@section('script')
@endsection
