{{-- addon:multivendor::admin/payout_requests/payment_modal.blade.php --}}

@php
    /** @var \App\Models\User $seller */
    $balance = (float) ($seller->current_balance ?? 0);

    $gcashEnabled =
        (int) ($seller->gcash_payout_status ?? 0) === 1 && filled($seller->gcash_name) && filled($seller->gcash_no);

    $bankEnabled =
        (int) ($seller->bank_payout_status ?? 0) === 1 &&
        filled($seller->bank_name) &&
        filled($seller->bank_acc_name) &&
        filled($seller->bank_acc_no);

    // keep row but show placeholder if routing not present on users table
    $bankRouting = $seller->bank_routing_no ?? '—';
@endphp

<form class="form-horizontal" action="{{ route('admin.pay_to_seller') }}" method="POST" enctype="multipart/form-data">
    @csrf

    {{-- Use USER id now --}}
    <input type="hidden" name="user_id" value="{{ $seller->id }}">
    <input type="hidden" name="withdraw_request_id" value="{{ $seller_withdraw_request->id }}">

    <div class="modal-header">
        <h5 class="modal-title h6">{{ translate('Pay to seller') }}</h5>
        <button type="button" class="close" data-dismiss="modal"></button>
    </div>

    <div class="modal-body">
        <table class="table table-striped table-bordered">
            <tbody>
                <tr>
                    @if ($balance >= 0)
                        <td>{{ translate('Due to seller') }}</td>
                        <td>{{ format_price($balance) }}</td>
                    @else
                        <td>{{ translate('Due from seller') }}</td>
                        <td>{{ format_price(abs($balance)) }}</td>
                    @endif
                </tr>
                <tr>
                    <td>{{ translate('Requested Amount is ') }}</td>
                    <td>{{ format_price($seller_withdraw_request->requested_amount) }}</td>
                </tr>
            </tbody>

            {{-- GCash block (from user) --}}
            @if ($gcashEnabled)
                <tbody>
                    <tr>
                        <td>{{ translate('GCash Name') }}</td>
                        <td>{{ $seller->gcash_name }}</td>
                    </tr>
                    <tr>
                        <td>{{ translate('Gcash No') }}</td>
                        <td>{{ $seller->gcash_no }}</td>
                    </tr>
                </tbody>
            @endif

            {{-- Bank block (from user) --}}
            @if ($bankEnabled)
                <tbody>
                    <tr>
                        <td>{{ translate('Bank Name') }}</td>
                        <td>{{ $seller->bank_name }}</td>
                    </tr>
                    <tr>
                        <td>{{ translate('Bank Account Name') }}</td>
                        <td>{{ $seller->bank_acc_name }}</td>
                    </tr>
                    <tr>
                        <td>{{ translate('Bank Account Number') }}</td>
                        <td>{{ $seller->bank_acc_no }}</td>
                    </tr>
                    <tr>
                        <td>{{ translate('Bank Routing Number') }}</td>
                        <td>{{ $bankRouting }}</td>
                    </tr>
                </tbody>
            @endif
        </table>

        @if ($balance > 0)
            {{-- Amount to pay: min(requested, balance) --}}
            @php
                $suggested = min((float) $seller_withdraw_request->requested_amount, $balance);
            @endphp

            <div class="form-group row">
                <label class="col-sm-3 col-from-label" for="amount">{{ translate('Amount') }}</label>
                <div class="col-sm-9">
                    <input type="number" lang="en" min="0" step="0.01" name="amount" id="amount"
                        value="{{ $suggested }}" class="form-control" required>
                </div>
            </div>

            {{-- Payment method (keep same options, sourced from user flags) --}}
            <div class="form-group row">
                <label class="col-sm-3 col-from-label" for="payment_option">{{ translate('Payment Method') }}</label>
                <div class="col-sm-9">
                    <select name="payment_option" id="payment_option" class="form-control aiz-selectpicker" required>
                        <option value="">{{ translate('Select Payment Method') }}</option>
                        @if ($gcashEnabled)
                            <option value="gcash">{{ translate('GCash') }}</option>
                        @endif
                        @if ($bankEnabled)
                            <option value="bank_payment">{{ translate('Bank Payment') }}</option>
                        @endif
                    </select>
                </div>
            </div>

            <div class="form-group row" id="txn_div">
                <label class="col-md-3 col-from-label" for="txn_code">{{ translate('Txn Code') }}</label>
                <div class="col-md-9">
                    <input type="text" name="txn_code" id="txn_code" class="form-control">
                </div>
            </div>
        @endif
    </div>

    <div class="modal-footer">
        @if ($balance > 0)
            <button type="submit" class="btn btn-primary">{{ translate('Pay') }}</button>
        @endif
        <button type="button" class="btn btn-light" data-dismiss="modal">{{ translate('Cancel') }}</button>
    </div>
</form>

<script>
    (function() {
        function toggleTxn() {
            var v = document.getElementById('payment_option').value;
            document.getElementById('txn_div').style.display = (v === 'bank_payment') ? '' : 'none';
        }
        var sel = document.getElementById('payment_option');
        if (sel) {
            sel.addEventListener('change', toggleTxn);
            toggleTxn();
        }
        if (window.AIZ && AIZ.plugins && AIZ.plugins.bootstrapSelect) {
            AIZ.plugins.bootstrapSelect('refresh');
        }
    })();
</script>
