@extends('backend.layouts.app')

@section('content')
    <div class="aiz-titlebar mt-2 mb-3">
        <h5 class="mb-0 h6">{{ translate('Update Package Information') }}</h5>
    </div>

    <div class="col-lg-10 mx-auto">
        <div class="card">
            <div class="card-body p-0">

                <form class="p-4" action="{{ route('admin.seller_packages.update', $seller_package->id) }}" method="POST">
                    <input type="hidden" name="_method" value="PATCH">
                    <input type="hidden" name="lang" value="{{ $lang }}">
                    @csrf
                    <div class="form-group row">
                        <label class="col-sm-2 col-from-label" for="name">{{ translate('Package Name') }}</label>
                        <div class="col-sm-10">
                            <input type="text" name="name"
                                value="{{ $seller_package->getTranslation('name', $lang) }}"
                                placeholder="{{ translate('Name') }}" id="name" class="form-control" required>
                        </div>
                    </div>
                    <div class="form-group row">
                        <label class="col-sm-2 col-from-label" for="geographic_level">Geographic Level</label>
                        <div class="col-sm-10">
                            <select name="geographic_level" id="geographic_level" class="form-control" required>
                                <option value="" disabled {{ !$seller_package->geographic_level ? 'selected' : '' }}>
                                    Select Geographic Level
                                </option>
                                <option value="0" {{ $seller_package->geographic_level == 0 ? 'selected' : '' }}>
                                    None</option>
                                <option value="1" {{ $seller_package->geographic_level == 1 ? 'selected' : '' }}>
                                    Barangay</option>
                                <option value="2" {{ $seller_package->geographic_level == 2 ? 'selected' : '' }}>
                                    City/Municipality</option>
                                <option value="3" {{ $seller_package->geographic_level == 3 ? 'selected' : '' }}>
                                    Provincial</option>
                                <option value="4" {{ $seller_package->geographic_level == 4 ? 'selected' : '' }}>
                                    Regional</option>
                            </select>
                        </div>
                    </div>
                    <div class="form-group row">
                        <label class="col-sm-2 col-from-label" for="amount">{{ translate('Amount') }}</label>
                        <div class="col-sm-10">
                            <div class="input-group">
                                <div class="input-group-append">
                                    <span class="input-group-text">₱</span>
                                </div>
                                <input type="number" name="amount" value="{{ $seller_package->amount }}" min="0"
                                    step="0.01" placeholder="{{ translate('Amount') }}" id="amount"
                                    class="form-control" required>
                            </div>
                        </div>
                    </div>
                    <div class="form-group row">
                        <label class="col-sm-2 col-form-label" for="commission">{{ translate('Sale Commission') }}</label>
                        <div class="col-sm-5">
                            <input type="number" min="0" step=".01" name="commission"
                                value="{{ $seller_package->commission }}" class="form-control" required>
                        </div>
                        <div class="col-sm-5">
                            <select name="commission_type" class="form-control" required>
                                <option value="percent"
                                    {{ $seller_package->commission_type == 'percent' ? 'selected' : '' }}>%</option>
                                <option value="flat" {{ $seller_package->commission_type == 'flat' ? 'selected' : '' }}>₱
                                </option>
                            </select>
                        </div>
                    </div>
                    <div class="form-group row">
                        <label class="col-sm-2 col-form-label"
                            for="ref_commission">{{ translate('Referral Commission') }}</label>
                        <div class="col-sm-5">
                            <input type="number" min="0" step=".01" name="ref_commission"
                                value="{{ $seller_package->ref_commission }}" class="form-control" required>
                        </div>
                        <div class="col-sm-5">
                            <select name="ref_commission_type" class="form-control" required>
                                <option value="percent"
                                    {{ $seller_package->ref_commission_type == 'percent' ? 'selected' : '' }}>%</option>
                                <option value="flat"
                                    {{ $seller_package->ref_commission_type == 'flat' ? 'selected' : '' }}>₱</option>
                            </select>
                        </div>
                    </div>
                    <div class="form-group row">
                        <label class="col-sm-2 col-form-label"
                            for="prod_discount">{{ translate('Product Discount') }}</label>
                        <div class="col-sm-5">
                            <input type="number" min="0" step=".01" name="prod_discount"
                                value="{{ $seller_package->prod_discount }}" class="form-control" required>
                        </div>
                        <div class="col-sm-5">
                            <select name="prod_discount_type" class="form-control" required>
                                <option value="percent"
                                    {{ $seller_package->prod_discount_type == 'percent' ? 'selected' : '' }}>%</option>
                                <option value="flat"
                                    {{ $seller_package->prod_discount_type == 'flat' ? 'selected' : '' }}>₱</option>
                            </select>
                        </div>
                    </div>
                    <div class="form-group row">
                        <label class="col-sm-2 col-form-label"
                            for="ref_sale_commission">{{ translate('Referral Sale Commission') }}</label>
                        <div class="col-sm-5">
                            <input type="number" min="0" step=".01" name="ref_sale_commission"
                                value="{{ $seller_package->ref_sale_commission }}" class="form-control" required>
                        </div>
                        <div class="col-sm-5">
                            <select name="ref_sale_commission_type" class="form-control" required>
                                <option value="percent"
                                    {{ $seller_package->ref_sale_commission_type == 'percent' ? 'selected' : '' }}>%
                                </option>
                                <option value="flat"
                                    {{ $seller_package->ref_sale_commission_type == 'flat' ? 'selected' : '' }}>₱</option>
                            </select>
                        </div>
                    </div>
                    <div class="form-group row">
                        <label class="col-sm-2 col-form-label"
                            for="area_sale_bonus">{{ translate('Area Sale Bonus') }}</label>
                        <div class="col-sm-5">
                            <input type="number" min="0" step=".01" name="area_sale_bonus"
                                value="{{ $seller_package->area_sale_bonus }}" class="form-control" required>
                        </div>
                        <div class="col-sm-5">
                            <select name="area_sale_bonus_type" class="form-control" required>
                                <option value="percent"
                                    {{ $seller_package->area_sale_bonus_type == 'percent' ? 'selected' : '' }}>%</option>
                                <option value="flat"
                                    {{ $seller_package->area_sale_bonus_type == 'flat' ? 'selected' : '' }}>₱</option>
                            </select>
                        </div>
                    </div>
                    <div class="form-group row">
                        <label class="col-md-2 col-form-label"
                            for="signinSrEmail">{{ translate('Package Logo') }}</label>
                        <div class="col-md-10">
                            <div class="input-group" data-toggle="aizuploader" data-type="image" data-multiple="false">
                                <div class="input-group-prepend">
                                    <div class="input-group-text bg-soft-secondary font-weight-medium">
                                        {{ translate('Browse') }}</div>
                                </div>
                                <div class="form-control file-amount">{{ translate('Choose File') }}</div>
                                <input type="hidden" name="logo" value="{{ $seller_package->logo }}"
                                    class="selected-files">
                            </div>
                            <div class="file-preview box sm">
                            </div>
                        </div>
                    </div>
                    <div class="form-group mb-0 text-right">
                        <button type="submit" class="btn btn-sm btn-primary">{{ translate('Save') }}</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
@endsection
