@extends('backend.layouts.app')

@section('content')
    <div class="aiz-titlebar mt-2 mb-3">
        <div class="row align-items-center">
            <div class="col-md-6">
                <h1 class="h3">{{ translate('Seller Packages') }}</h1>
            </div>
            <div class="col-md-6 text-md-right">
                <a href="{{ route('admin.seller_packages.create') }}" class="btn btn-primary">
                    <span>{{ translate('Add New Package') }}</span>
                </a>
            </div>
        </div>
    </div>


    <div class="row">
        {{-- PACKAGE RELATED LOGIC --}}
        @foreach ($seller_packages as $key => $seller_package)
            <div class="col-lg-4 col-md-4 col-sm-12">
                <div class="card">
                    <div class="card-body text-center">
                        <img alt="{{ translate('Package Logo') }}" src="{{ uploaded_asset($seller_package->logo) }}"
                            class="mw-100 mx-auto mb-4" height="150px">
                        <p class="mb-3 h6 fw-600">{{ $seller_package->name }}</p>
                        @php
                            $levels = [
                                0 => 'None',
                                1 => 'Barangay',
                                2 => 'City/Municipality',
                                3 => 'Provincial',
                                4 => 'Regional',
                            ];
                        @endphp

                        <p class="fs-15">{{ $levels[$seller_package->geographic_level] ?? 'N/A' }}</p>

                        <p class="h4">{{ format_price($seller_package->amount) }}</p>
                        <p class="fs-15">{{ translate('Sale Commission') }}:
                            <b class="text-bold">
                                @if ($seller_package->commission_type == 'percent')
                                    {{ $seller_package->commission }}%
                                @else
                                    ₱{{ $seller_package->commission }}
                                @endif
                            </b>
                        </p>

                        <p class="fs-15">{{ translate('Referral Commission') }}:
                            <b class="text-bold">
                                @if ($seller_package->ref_commission_type == 'percent')
                                    {{ $seller_package->ref_commission }}%
                                @else
                                    ₱{{ $seller_package->ref_commission }}
                                @endif
                            </b>
                        </p>

                        <p class="fs-15">{{ translate('Product Discount') }}:
                            <b class="text-bold">
                                @if ($seller_package->prod_discount_type == 'percent')
                                    {{ $seller_package->prod_discount }}%
                                @else
                                    ₱{{ $seller_package->prod_discount }}
                                @endif
                            </b>
                        </p>

                        <p class="fs-15">{{ translate('Referral Sale Commission') }}:
                            <b class="text-bold">
                                @if ($seller_package->ref_sale_commission_type == 'percent')
                                    {{ $seller_package->ref_sale_commission }}%
                                @else
                                    ₱{{ $seller_package->ref_sale_commission }}
                                @endif
                            </b>
                        </p>

                        <p class="fs-15">{{ translate('Area Sale Bonus') }}:
                            <b class="text-bold">
                                @if ($seller_package->area_sale_bonus_type == 'percent')
                                    {{ $seller_package->area_sale_bonus }}%
                                @else
                                    ₱{{ $seller_package->area_sale_bonus }}
                                @endif
                            </b>
                        </p>

                        <div class="mar-top">
                            <a href="{{ route('admin.seller_packages.edit', ['id' => $seller_package->id, 'lang' => env('DEFAULT_LANGUAGE')]) }}"
                                class="btn btn-sm btn-info">{{ translate('Edit') }}</a>
                            <a href="#" data-href="{{ route('admin.seller_packages.destroy', $seller_package->id) }}"
                                class="btn btn-sm btn-danger confirm-delete">{{ translate('Delete') }}</a>
                        </div>
                    </div>
                </div>
            </div>
        @endforeach
    </div>
@endsection

@section('modal')
    @include('backend.inc.delete_modal')
@endsection
