    <form class="" id="package_payment_form" action="{{ route('seller.package.package_purchase_confirm') }}"
        method="post">
        @csrf

        <div class="modal-header">
            <h5 class="modal-title h6">{{ translate('Purchase Package') }}</h5>
            <button type="button" class="close" data-dismiss="modal">
            </button>
        </div>

        <input type="hidden" name="id" value="{{ $seller_packages->id }}">
        <input type="hidden" name="userId" value="{{ auth()->user()->id }}">

        <div class="modal-body gry-bg px-3 pt-3 mx-auto">

            @if ($errors->any())
                <div class="alert alert-danger mb-3">
                    <ul class="mb-0">
                        @foreach ($errors->all() as $error)
                            <li>{{ $error }}</li>
                        @endforeach
                    </ul>
                </div>
            @endif

            <div class="align-items-center gutters-5 row">

                <div class="col">
                    <div class="card overflow-hidden">
                        <div class="card-body d-flex align-items-center justify-content-center"
                            style="display: flex; flex-direction: column;">
                            <div class="text-center mb-4 mt-3 col-6 col-md-4">
                                <img class="img-fluid mb-2" src="{{ uploaded_asset($seller_packages->logo) }}"
                                    height="100">
                                <h5 class="mb-3 h5 fw-600">{{ $seller_packages->getTranslation('name') }}</h5>
                                <span class="h5 fw-600 lh-1 mb-0">{{ format_price($seller_packages->amount) }}</span>
                            </div>
                            <ul class="list-group list-group-raw fs-15 mb-5">
                                <li class="list-group-item py-2">
                                    <i class="las la-check text-success mr-2"></i>{{ $seller_packages->commission }}%
                                    {{ translate('Sale Commission') }}
                                </li>
                                <li class="list-group-item py-2">
                                    <i
                                        class="las la-check text-success mr-2"></i>{{ $seller_packages->ref_commission }}%
                                    {{ translate('Referral Commission') }}
                                </li>
                                <li class="list-group-item py-2">
                                    <i
                                        class="las la-check text-success mr-2"></i>{{ $seller_packages->prod_discount }}%
                                    {{ translate('Product Discount') }}
                                </li>
                                <li class="list-group-item py-2">
                                    <i class="las la-check text-success mr-2"></i>₱
                                    {{ $seller_packages->ref_sale_commission }}
                                    {{ translate('Referral Sale Commission') }}
                                </li>
                                <li class="list-group-item py-2">
                                    <i class="las la-check text-success mr-2"></i>₱
                                    {{ $seller_packages->area_sale_bonus }}
                                    {{ translate('Area Sale Bonus') }}
                                </li>
                            </ul>
                        </div>
                        {{-- @if ($seller_packages->id !== 1)
                            <div class="card-body d-flex align-items-center justify-content-center">
                                <label class="col-sm-4 fs-15 col-from-label">
                                    @if ($seller_packages->id == 13 || $seller_packages->id == 12)
                                        {{ translate('Select City/Municipality') }}
                                    @elseif ($seller_packages->id == 14)
                                        {{ translate('Select Province') }}
                                    @endif
                                </label>
                                <div class="col-sm-9">
                                    @if ($seller_packages->id == 13 || $seller_packages->id == 12)
                                        <select id="city_select" name="selected_city"
                                            class="form-control aiz-selectpicker" data-live-search="true" required>
                                            @foreach ($cities as $city)
                                                <option value="{{ $city->id }}">{{ $city->name }}</option>
                                            @endforeach
                                        </select>
                                    @elseif ($seller_packages->id == 14)
                                        <select name="selected_state" class="form-control aiz-selectpicker"
                                            data-live-search="true" required>
                                            @foreach ($states as $state)
                                                <option value="{{ $state->id }}">{{ $state->name }}</option>
                                            @endforeach
                                        </select>
                                    @elseif ($seller_packages->id == 15)
                                        <select name="selected_region" class="form-control aiz-selectpicker"
                                            data-live-search="true" required>
                                            @foreach ($regions as $region)
                                                <option value="{{ $region->id }}">{{ $region->name }}</option>
                                            @endforeach
                                        </select>
                                    @endif
                                </div>
                            </div>
                        @endif

                        @if ($seller_packages->id == 12)
                            <div class="card-body d-flex align-items-center justify-content-center"
                                id="barangay_select_div" style="display: none;">
                                <label class="col-sm-4 fs-15 col-from-label">
                                    {{ translate('Select Barangay') }}
                                </label>
                                <div class="col-sm-9">
                                    <select id="barangay_select" name="selected_barangay"
                                        class="form-control aiz-selectpicker" data-live-search="true" required>
                                    </select>
                                </div>
                            </div>
                        @endif --}}

                        {{-- show a selector only if package needs a location --}}
                        @if ((int) $seller_packages->geographic_level > 0)
                            <div class="card-body d-flex align-items-center justify-content-center">
                                <label class="col-sm-4 fs-15 col-from-label">
                                    @if ((int) $seller_packages->geographic_level === 1 || (int) $seller_packages->geographic_level === 2)
                                        {{ translate('Select City/Municipality') }}
                                    @elseif ((int) $seller_packages->geographic_level === 3)
                                        {{ translate('Select Province') }}
                                    @elseif ((int) $seller_packages->geographic_level === 4)
                                        {{ translate('Select Region') }}
                                    @endif
                                </label>

                                <div class="col-sm-9">
                                    @if ((int) $seller_packages->geographic_level === 1 || (int) $seller_packages->geographic_level === 2)
                                        <select id="city_select" name="selected_city"
                                            class="form-control aiz-selectpicker" data-live-search="true"
                                            data-none-results-text="{{ translate('No matches found') }}"
                                            title="{{ translate('Choose a city/municipality') }}"
                                            {{ (int) $seller_packages->geographic_level === 1 ? 'required' : '' }}
                                            {{ (int) $seller_packages->geographic_level === 2 ? 'required' : '' }}>
                                            @foreach ($cities as $city)
                                                <option value="{{ $city->id }}"
                                                    {{ (int) old('selected_city') === (int) $city->id ? 'selected' : '' }}>
                                                    {{ $city->name }}
                                                </option>
                                            @endforeach
                                        </select>
                                    @elseif ((int) $seller_packages->geographic_level === 3)
                                        <select name="selected_state" class="form-control aiz-selectpicker"
                                            data-live-search="true"
                                            data-none-results-text="{{ translate('No matches found') }}"
                                            title="{{ translate('Choose a province') }}" required>
                                            @foreach ($states as $state)
                                                <option value="{{ $state->id }}"
                                                    {{ (int) old('selected_state') === (int) $state->id ? 'selected' : '' }}>
                                                    {{ $state->name }}
                                                </option>
                                            @endforeach
                                        </select>
                                    @elseif ((int) $seller_packages->geographic_level === 4)
                                        <select name="selected_region" class="form-control aiz-selectpicker"
                                            data-live-search="true"
                                            data-none-results-text="{{ translate('No matches found') }}"
                                            title="{{ translate('Choose a region') }}" required>
                                            @foreach ($regions as $region)
                                                <option value="{{ $region->id }}"
                                                    {{ (int) old('selected_region') === (int) $region->id ? 'selected' : '' }}>
                                                    {{ $region->name }}
                                                </option>
                                            @endforeach
                                        </select>
                                    @endif
                                </div>
                            </div>
                        @endif

                        @if ((int) $seller_packages->geographic_level === 1)
                            <div class="card-body d-flex align-items-center justify-content-center"
                                id="barangay_select_div" style="display:none;">
                                <label class="col-sm-4 fs-15 col-from-label">{{ translate('Select Barangay') }}</label>
                                <div class="col-sm-9">
                                    <select id="barangay_select" name="selected_barangay"
                                        class="form-control aiz-selectpicker" data-live-search="true"
                                        data-none-results-text="{{ translate('No matches found') }}"
                                        title="{{ translate('Choose a barangay') }}" required></select>
                                </div>
                            </div>
                        @endif


                    </div>
                </div>
            </div>
            <div class="form-group text-right">
                <button type="submit" class="btn btn-sm btn-primary transition-3d-hover mr-1">Confirm</button>
            </div>
        </div>
    </form>

    <script>
        $(function() {
            $('.aiz-selectpicker').selectpicker('refresh');

            var baseUrl = '{{ URL::to('/') }}';
            var preCity = '{{ old('selected_city') }}';
            var preBarangay = '{{ old('selected_barangay') }}';

            // Load barangays automatically if a city was already selected (geo level 1)
            if (preCity) {
                $('#city_select').val(preCity).change();
            }

            $('#city_select').on('change', function() {
                var cityId = $(this).val();
                if (!cityId) {
                    $('#barangay_select_div').hide();
                    return;
                }
                $.ajax({
                    url: baseUrl + '/api/v1/get-barangays/' + cityId,
                    type: 'GET',
                    success: function(response) {
                        var barangays = response.barangays || [];
                        var $b = $('#barangay_select');
                        $b.empty();
                        $.each(barangays, function(_, item) {
                            var selected = preBarangay && String(preBarangay) ===
                                String(item.id) ? 'selected' : '';
                            $b.append('<option value="' + item.id + '" ' + selected +
                                '>' + item.name + '</option>');
                        });
                        $('#barangay_select_div').show();
                        $b.selectpicker('refresh');
                    },
                    error: function(xhr) {
                        console.error(xhr.responseText || xhr.statusText);
                    }
                });
            });
        });
    </script>
