@extends('addon:multivendor::seller.layouts.app')

@section('content')
    @php
        $user = auth()->user(); // ✅ fix
        $currentPackage = optional($user->seller_package);
        $currentPackageId = $currentPackage->id; // null if none
    @endphp

    <section class="py-4 py-lg-5">
        <div class="container">
            <div class="alert alert-info">
                {{ translate('Your current package -') }}
                <span class="fw-600">{{ $currentPackage->name ?? translate('None') }}</span> {{-- ✅ null-safe --}}
            </div>

            <div class="row row-cols-xxl-4 row-cols-lg-3 row-cols-md-2 row-cols-1 gutters-10 justify-content-center">
                @foreach ($seller_packages as $key => $seller_package)
                    <div class="col">
                        <div class="card overflow-hidden">
                            <div class="card-body">
                                <div class="text-center mb-4 mt-3">
                                    <img class="mw-100 mx-auto mb-4" src="{{ uploaded_asset($seller_package->logo) }}"
                                        height="100">
                                    <h5 class="mb-3 h5 fw-600">{{ $seller_package->getTranslation('name') }}</h5>
                                </div>
                                <ul class="list-group list-group-raw fs-15 mb-5">
                                    <li class="list-group-item py-2">
                                        <i class="las la-check text-success mr-2"></i>
                                        {{ translate('Sale Commission') }}: {{ $seller_package->commission }}%
                                    </li>
                                    <li class="list-group-item py-2">
                                        <i class="las la-check text-success mr-2"></i>
                                        {{ translate('Referral Commission') }}: {{ $seller_package->ref_commission }}%
                                    </li>
                                    <li class="list-group-item py-2">
                                        <i class="las la-check text-success mr-2"></i>{{ translate('Product Discount') }}:
                                        {{ $seller_package->prod_discount }}%

                                    </li>
                                    <li class="list-group-item py-2">
                                        <i class="las la-check text-success mr-2"></i>
                                        {{ translate('Referral Sale Commission') }}: ₱
                                        {{ $seller_package->ref_sale_commission }}
                                    </li>
                                    <li class="list-group-item py-2">
                                        <i class="las la-check text-success mr-2"></i>
                                        {{ translate('Area Sale Bonus') }}: ₱
                                        {{ $seller_package->area_sale_bonus }}
                                    </li>
                                </ul>

                                <div class="text-center">
                                    @php
                                        $isCurrent = (int) $seller_package->id === (int) ($currentPackageId ?? 0);
                                        $isDisabledByHistory = in_array($seller_package->id, $disabledPackages ?? []);
                                        $isAffiliate = $seller_package->name === 'Affiliate'; // if you really want to block this by name
                                    @endphp

                                    @if ($isDisabledByHistory || $isCurrent || $isAffiliate)
                                        <button class="btn btn-primary fw-600" disabled>
                                            {{ translate('Purchase Package') }}
                                        </button>
                                    @else
                                        <button class="btn btn-primary fw-600"
                                            onclick="select_payment_method_modal({{ $seller_package->id }})">
                                            {{ translate('Purchase Package') }}
                                        </button>
                                    @endif
                                </div>

                            </div>
                        </div>
                    </div>
                @endforeach
            </div>
        </div>
    </section>
@endsection


@section('modal')
    <!-- package purchase modal -->
    <div class="modal fade" id="package_purchase_modal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel"
        aria-hidden="true">
        <div class="modal-dialog modal-md modal-dialog-centered" role="document">
            <div class="modal-content" id="seller-package-purchase-modal-content"></div>
        </div>
    </div>
@endsection

@section('script')
    <script>
        function select_payment_method_modal(id) {
            $.post('{{ route('seller.package.package_purchase_modal') }}', {
                _token: '{{ csrf_token() }}',
                id: id
            }, function(html) {
                $('#seller-package-purchase-modal-content').html(html);
                $('#package_purchase_modal').modal('show', {
                    backdrop: 'static'
                });
            });
        }

        @if (session('package_modal_id'))
            $(function() {
                select_payment_method_modal({{ (int) session('package_modal_id') }});
            });
        @endif
    </script>
@endsection
