<?php

namespace App\Http\Controllers;

use App\Models\Tag;
use Illuminate\Http\Request;
use Illuminate\Http\Response;

class TagController extends Controller
{
  // DELETE /admin/tags/{tag}  -> name: tags.destroy.ajax
  public function destroyAjax(Tag $tag)
  {
    // Detach all product relations then delete the tag
    $tag->products()->detach();
    $tag->delete();

    return response()->json([
      'ok'      => true,
      'message' => translate('Tag deleted successfully.'),
      'id'      => (int) $tag->id,
    ], Response::HTTP_OK);
  }

  public function destroy($id)
  {
    $tag = \App\Models\Tag::findOrFail($id);

    $tag->products()->detach();
    $tag->delete();

    flash(translate('Tag deleted successfully!'))->success();

    $returnTo = request('return_to');
    if ($returnTo && filter_var($returnTo, FILTER_VALIDATE_URL)) {
      return redirect()->to($returnTo);
    }
    return redirect()->back();
  }
}
