<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class UserLocationAssignment extends Model
{
  protected $fillable = [
    'user_id',
    'geographic_level',   // 1=barangay, 2=city, 3=state, 4=region
    'location_id',
    'seller_type',
    'is_active',
  ];

  protected $guarded = [];

  public function user()
  {
    return $this->belongsTo(User::class);
  }
}
