<?php

namespace App\Notifications;

use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Notifications\Messages\MailMessage;
use Illuminate\Notifications\Notification;

class PaidNotificationAdmin extends Notification
{
    use Queueable;
    public $order;

    /**
     * Create a new notification instance.
     *
     * @param  \App\Models\Order  $order
     * @return void
     */
    public function __construct($order)
    {
        $this->order = $order;
    }

    /**
     * Get the notification's delivery channels.
     *
     * @param  mixed  $notifiable
     * @return array
     */
    public function via($notifiable)
    {
        return ['mail'];
    }

    /**
     * Get the mail representation of the notification.
     *
     * @param  mixed  $notifiable
     * @return \Illuminate\Notifications\Messages\MailMessage
     */
    public function toMail($notifiable)
    {
        return (new MailMessage)
            ->subject('New Order Payment Received')
            ->greeting('Hello Admin,')
            ->line('An order has been marked as paid.')
            ->line('Customer: ' . $this->order->name)
            ->line('Order Code: ' . $this->order->combined_order->code)
            ->line('Sub Total: ' . format_price($this->order->orderDetails->sum('total')))
            ->line('Shipping: ' . format_price($this->order->shipping_cost))
            ->line('Total: ' . format_price($this->order->orderDetails->sum('total') + $this->order->shipping_cost))
            ->action('View Order', url('/admin/orders/' . $this->order->id))
            ->line('Thank you for using our application!');
    }

    /**
     * Get the array representation of the notification.
     *
     * @param  mixed  $notifiable
     * @return array
     */
    public function toArray($notifiable)
    {
        return [
            'order_id' => $this->order->id,
            'payment_status' => $this->order->payment_status,
        ];
    }
}
