<?php

namespace App\Services;

use Illuminate\Support\Facades\Http;

class WooCommerceService
{
  protected $url;
  protected $key;
  protected $secret;

  public function __construct()
  {
    $this->url = rtrim(config('services.woocommerce.url'), '/');
    $this->key = config('services.woocommerce.key');
    $this->secret = config('services.woocommerce.secret');
  }

  // CREATE product on WooCommerce
  public function createProduct(array $data)
  {
    return Http::withBasicAuth($this->key, $this->secret)
      ->post("{$this->url}/wp-json/wc/v3/products", $data)
      ->json();
  }

  // UPDATE product on WooCommerce
  public function updateProduct($wcProductId, array $data)
  {
    return Http::withBasicAuth($this->key, $this->secret)
      ->put("{$this->url}/wp-json/wc/v3/products/{$wcProductId}", $data)
      ->json();
  }

  // DELETE product on WooCommerce
  public function deleteProduct($wcProductId)
  {
    return Http::withBasicAuth($this->key, $this->secret)
      ->delete("{$this->url}/wp-json/wc/v3/products/{$wcProductId}?force=true")
      ->json();
  }

  public function createOrGetCategory($name)
  {
    $response = Http::withBasicAuth($this->key, $this->secret)
      ->get("{$this->url}/wp-json/wc/v3/products/categories", [
        'search' => $name,
        'per_page' => 1,
      ])
      ->json();

    if (is_array($response) && count($response) > 0) {
      return $response[0];
    }

    return Http::withBasicAuth($this->key, $this->secret)
      ->post("{$this->url}/wp-json/wc/v3/products/categories", [
        'name' => $name,
      ])
      ->json();
  }

  public function createOrGetTag($name)
  {
    $response = Http::withBasicAuth($this->key, $this->secret)
      ->get("{$this->url}/wp-json/wc/v3/products/tags", [
        'search' => $name,
        'per_page' => 1,
      ])
      ->json();

    if (is_array($response) && count($response) > 0) {
      return $response[0];
    }

    return Http::withBasicAuth($this->key, $this->secret)
      ->post("{$this->url}/wp-json/wc/v3/products/tags", [
        'name' => $name,
      ])
      ->json();
  }
}
