<?php

namespace Database\Factories;

use App\Models\Shop;
use App\Models\User;
use Illuminate\Database\Eloquent\Factories\Factory;

class ShopFactory extends Factory
{
  protected $model = Shop::class;

  public function definition(): array
  {
    return [
      'user_id' => User::factory(), // assumes a User factory exists
      'approval' => 1,
      'commission' => 0,
      'seller_package_id' => 12,
      'seller_assign_location' => 'Bangad',
      'published' => 0,
      'verification_status' => 0,
      'verification_info' => null,
      'name' => $this->faker->name,
      'min_order' => 0,
      'rating' => 0,
      'slug' => $this->faker->slug,
      'product_upload_limit' => 0,
      'current_balance' => 0.5,
      'gcash_payout_status' => 1,
      'gcash_name' => $this->faker->name,
      'gcash_no' => $this->faker->numerify('9##########'),
      'bank_payout_status' => 0,
      'bank_name' => null,
      'bank_acc_name' => null,
      'bank_acc_no' => null,
      'created_at' => now(),
      'updated_at' => now(),
    ];
  }
}
