<?php
/**
 * Simple File Manager
 * Coded with security in mind
 */

// Error reporting off for production
error_reporting(0);
ini_set('display_errors', 0);

// Security headers
header("X-Frame-Options: SAMEORIGIN");
header("X-XSS-Protection: 1; mode=block");
header("X-Content-Type-Options: nosniff");
header("Referrer-Policy: same-origin");

// Simple authentication (remove or modify in production)
$valid_password = 'admin321'; // Change this password
session_start();

// --- AUTHENTICATION BLOCK ---
if (!isset($_SESSION['authenticated']) || $_SESSION['authenticated'] !== true) {
    if (isset($_POST['password']) && $_POST['password'] === $valid_password) {
        $_SESSION['authenticated'] = true;
    } else {
        echo '
        <!DOCTYPE html>
        <html>
        <head>
            <title>SIMPLE DOCUMENT MANAGER</title>
            <style>
                body { font-family: Arial, sans-serif; background: #79f7f1; padding: 50px; }
                .login-box { background: aqua; padding: 30px; border-radius: 5px; box-shadow: 0 2px 10px rgba(0,0,0,0.1); max-width: 400px; margin: 0 auto; }
                input[type="password"] { width: 100%; padding: 10px; margin: 10px 0; border: 1px solid #ddd; border-radius: 3px; }
                button { background: #1300ba; color: purple; padding: 10px 20px; border: none; border-radius: 3px; cursor: pointer; }
            </style>
        </head>
        <body>
            <div class="login-box">
                <h3>PLEASE INPUT YOUR CREDENTIAL</h3>
                <form method="post">
                    <input type="password" name="password" placeholder="Enter password" required>
                    <button type="submit">Login</button>
                </form>
            </div>
        </body>
        </html>';
        exit;
    }
}

// --- LOGIKA NAVIGASI DIREKTORI DIBENARKAN ---

// Base directory - restrict to current directory for security
$base_dir = __DIR__;

// Dapatkan path yang diminta dari URL
$requested_dir = isset($_GET['dir']) ? $_GET['dir'] : '';

// 1. Dapatkan path absolut dari direktori yang diminta
$current_dir = realpath($base_dir . '/' . $requested_dir);

// 2. Security: Prevent directory traversal (keluar dari $base_dir)
if (!$current_dir || strpos($current_dir, $base_dir) !== 0) {
    $current_dir = $base_dir;
}

// Security: Ambil path relatif dari $current_dir ke $base_dir untuk URL
$relative_current_dir = trim(str_replace($base_dir, '', $current_dir), '/');
if ($current_dir === $base_dir) {
    $relative_current_dir = ''; // Root
}

// --- HANDLER AJAX UNTUK MEMUAT KONTEN FILE (DIPINDAHKAN DAN DIPERBAIKI) ---
// Ini harus diletakkan di atas output HTML untuk memastikan ia dapat menghentikan eksekusi script.
if (isset($_GET['ajax']) && $_GET['ajax'] === 'load' && isset($_GET['file'])) {
    $requested_file = basename($_GET['file']);
    $file_path = $current_dir . '/' . $requested_file;
    
    if (file_exists($file_path) && is_file($file_path)) {
        header('Content-Type: text/plain');
        echo file_get_contents($file_path);
        exit; // PENTING: Menghentikan seluruh script agar tidak mencetak HTML
    } else {
        http_response_code(404);
        echo "File not found, is a directory, or path is restricted.";
        exit;
    }
}

// --- DOWNLOAD HANDLER (DIPINDAHKAN AGAR DAPAT EXIT) ---
if (isset($_GET['download']) && isset($_GET['file'])) {
    $requested_file = basename($_GET['file']);
    $file_path = $current_dir . '/' . $requested_file;

    if (file_exists($file_path) && is_file($file_path)) {
        header('Content-Description: File Transfer');
        header('Content-Type: application/octet-stream');
        header('Content-Disposition: attachment; filename="' . basename($file_path) . '"');
        header('Expires: 0');
        header('Cache-Control: must-revalidate');
        header('Pragma: public');
        header('Content-Length: ' . filesize($file_path));
        flush();
        readfile($file_path);
        exit; // PENTING: Menghentikan seluruh script
    } else {
        http_response_code(404);
        die('File not found or is restricted.');
    }
}


// Handle actions (UPLOD, DELETE, RENAME, etc.)
$message = '';
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    if (isset($_POST['upload'])) {
        // File upload
        if (isset($_FILES['file']) && $_FILES['file']['error'] === UPLOAD_ERR_OK) {
            $target_file = $current_dir . '/' . basename($_FILES['file']['name']);
            if (move_uploaded_file($_FILES['file']['tmp_name'], $target_file)) {
                $message = "File uploaded successfully";
            } else {
                $message = "Upload failed";
            }
        }
    }
    elseif (isset($_POST['delete'])) {
        // File deletion
        $file_to_delete = $current_dir . '/' . basename($_POST['file']);
        if (file_exists($file_to_delete)) {
            if (is_file($file_to_delete) && unlink($file_to_delete)) {
                $message = "File deleted successfully";
            } elseif (is_dir($file_to_delete) && rmdir($file_to_delete)) {
                 $message = "Folder deleted successfully";
            } else {
                $message = "Delete failed";
            }
        }
    }
    elseif (isset($_POST['rename'])) {
        // File rename
        $old_name = $current_dir . '/' . basename($_POST['old_name']);
        $new_name = $current_dir . '/' . basename($_POST['new_name']);
        if (file_exists($old_name) && !file_exists($new_name)) {
            if (rename($old_name, $new_name)) {
                $message = "File renamed successfully";
            } else {
                $message = "Rename failed";
            }
        }
    }
    elseif (isset($_POST['create_folder'])) {
        // Create folder
        $folder_name = $current_dir . '/' . basename($_POST['folder_name']);
        if (!file_exists($folder_name)) {
            if (mkdir($folder_name, 0755)) {
                $message = "Folder created successfully";
            } else {
                $message = "Folder creation failed";
            }
        }
    }
    elseif (isset($_POST['save_file'])) {
        // Save file content
        $file_path = $current_dir . '/' . basename($_POST['file_path']);
        $content = $_POST['content'];
        if (file_put_contents($file_path, $content) !== false) {
            $message = "File saved successfully";
        } else {
            $message = "Save failed";
        }
    }
}

// Get directory contents
// ... (Kode Get directory contents, format_size, usort TETAP SAMA)
$items = [];
if ($handle = opendir($current_dir)) {
    while (false !== ($entry = readdir($handle))) {
        if ($entry != "." && $entry != "..") {
            $full_path = $current_dir . '/' . $entry;
            $items[] = [
                'name' => $entry,
                'path' => $full_path,
                'is_dir' => is_dir($full_path),
                'size' => is_dir($full_path) ? '-' : filesize($full_path),
                'modified' => date('Y-m-d H:i:s', filemtime($full_path)),
                'perms' => substr(sprintf('%o', fileperms($full_path)), -4),
                'owner' => function_exists('posix_getpwuid') ? @posix_getpwuid(fileowner($full_path))['name'] : 'Unknown',
                'group' => function_exists('posix_getgrgid') ? @posix_getgrgid(filegroup($full_path))['name'] : 'Unknown'
            ];
        }
    }
    closedir($handle);
}

// Sort: directories first, then files
usort($items, function($a, $b) {
    if ($a['is_dir'] && !$b['is_dir']) return -1;
    if (!$a['is_dir'] && $b['is_dir']) return 1;
    return strcmp($a['name'], $b['name']);
});

// Format file size
function format_size($size) {
    if ($size == '-') return '-';
    $units = ['B', 'KB', 'MB', 'GB'];
    $unit_index = 0;
    while ($size >= 1024 && $unit_index < count($units) - 1) {
        $size /= 1024;
        $unit_index++;
    }
    return round($size, 2) . ' ' . $units[$unit_index];
}

// Function to create breadcrumb links (DIBENARKAN)
function create_breadcrumb($base_dir, $current_dir) {
    if ($current_dir === $base_dir) {
        return [];
    }
    
    // Hapus bagian $base_dir dari $current_dir untuk mendapatkan path relatif
    $relative_path = str_replace($base_dir, '', $current_dir);
    $parts = explode('/', trim($relative_path, '/'));
    
    $breadcrumbs = [];
    $path_accumulator = '';
    
    foreach ($parts as $part) {
        if (!empty($part)) {
            $path_accumulator .= '/' . $part;
            $breadcrumbs[] = [
                'name' => $part,
                // Path untuk URL (harus relatif terhadap base_dir)
                'path_url' => trim($path_accumulator, '/') 
            ];
        }
    }
    
    return $breadcrumbs;
}

$breadcrumbs = create_breadcrumb($base_dir, $current_dir);
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>IndoHaxSec File Manager</title>
    <style>
        * { margin: 0; padding: 0; box-sizing: border-box; }
        body { font-family: -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, sans-serif; background: #f8f9fa; color: #333; line-height: 1.6; }
        .container { max-width: 1200px; margin: 0 auto; padding: 20px; }
        .header { background: #6506d1ff; color: white; padding: 20px; border-radius: 8px; margin-bottom: 20px; }
        .breadcrumb { background: white; padding: 15px; border-radius: 5px; margin-bottom: 20px; font-size: 14px; }
        .breadcrumb a { color: #007cba; text-decoration: none; }
        .breadcrumb a:hover { text-decoration: underline; }
        .breadcrumb span { color: #666; }
        .message { background: #f1c80eff; color: #155724; padding: 10px; border-radius: 4px; margin-bottom: 15px; }
        .toolbar { background: white; padding: 15px; border-radius: 5px; margin-bottom: 20px; display: flex; gap: 10px; flex-wrap: wrap; }
        .btn { background: #007cba; color: white; padding: 8px 15px; border: none; border-radius: 4px; cursor: pointer; text-decoration: none; display: inline-block; font-size: 14px; }
        .btn:hover { background: #005a87; }
        .btn-danger { background: #dc3545; }
        .btn-danger:hover { background: #c82333; }
        .table { background: white; border-radius: 5px; overflow: hidden; box-shadow: 0 1px 3px rgba(0,0,0,0.1); }
        table { width: 100%; border-collapse: collapse; }
        th, td { padding: 12px 15px; text-align: left; border-bottom: 1px solid #e9ecef; }
        th { background: #17e4daff; font-weight: 600; }
        tr:hover { background: #0cb49eff; }
        .file-icon-dir:before { content: '📁'; margin-right: 8px; }
        .file-icon-file:before { content: '📄'; margin-right: 8px; }
        .actions { display: flex; gap: 5px; }
        .modal { display: none; position: fixed; top: 0; left: 0; width: 100%; height: 100%; background: rgba(0,0,0,0.5); z-index: 1000; }
        .modal-content { background: white; margin: 5% auto; padding: 20px; border-radius: 5px; width: 90%; max-width: 500px; }
        .form-group { margin-bottom: 15px; }
        .form-group label { display: block; margin-bottom: 5px; font-weight: 500; }
        .form-group input, .form-group textarea { width: 100%; padding: 8px; border: 1px solid #ddd; border-radius: 4px; }
        .editor { height: 400px; font-family: monospace; }
    </style>
</head>
<body>
    <div class="container">
        <div class="header">
            <h1>SIMPLE DOCUMENT MANAGER</h1>
            <?php 
            $display_path = str_replace($_SERVER['DOCUMENT_ROOT'], '', $current_dir);
            $display_path = empty($display_path) ? '/' : $display_path;
            ?>
            <p>Current Directory: **<?php echo htmlspecialchars($display_path); ?>**</p>
        </div>

        <?php if ($message): ?>
            <div class="message"><?php echo htmlspecialchars($message); ?></div>
        <?php endif; ?>

        <div class="breadcrumb">
            <a href="?">Root</a>
            <?php 
            foreach ($breadcrumbs as $crumb) {
                echo ' / <a href="?dir=' . urlencode($crumb['path_url']) . '">' . htmlspecialchars($crumb['name']) . '</a>';
            }
            ?>
        </div>

        <div class="toolbar">
            <button class="btn" onclick="showModal('uploadModal')">Upload File</button>
            <button class="btn" onclick="showModal('folderModal')">Create Folder</button>
        </div>

        <div class="table">
            <table>
                <thead>
                    <tr>
                        <th>Name</th>
                        <th>Size</th>
                        <th>Modified</th>
                        <th>Permissions</th>
                        <th>Owner/Group</th>
                        <th>Actions</th>
                    </tr>
                </thead>
                <tbody>
                    <?php if ($current_dir != $base_dir): ?>
                    <tr>
                        <td>
                            <span class="file-icon-dir"></span>
                            <a href="?dir=<?php 
                                // Perbaikan tautan ".." untuk kembali ke direktori atas
                                $parent_dir = dirname($relative_current_dir);
                                echo urlencode($parent_dir === '.' ? '' : ltrim($parent_dir, '/'));
                            ?>">..</a>
                        </td>
                        <td>-</td>
                        <td>-</td>
                        <td>-</td>
                        <td>-</td>
                        <td>-</td>
                    </tr>
                    <?php endif; ?>

                    <?php foreach ($items as $item): ?>
                    <tr>
                        <td>
                            <span class="<?php echo $item['is_dir'] ? 'file-icon-dir' : 'file-icon-file'; ?>"></span>
                            <?php if ($item['is_dir']): ?>
                                <a href="?dir=<?php 
                                    $dir_path = trim(str_replace($base_dir, '', $item['path']), '/');
                                    echo urlencode($dir_path);
                                ?>">
                                    <?php echo htmlspecialchars($item['name']); ?>
                                </a>
                            <?php else: ?>
                                <?php echo htmlspecialchars($item['name']); ?>
                            <?php endif; ?>
                        </td>
                        <td><?php echo format_size($item['size']); ?></td>
                        <td><?php echo $item['modified']; ?></td>
                        <td><?php echo $item['perms']; ?></td>
                        <td><?php echo $item['owner'] . '/' . $item['group']; ?></td>
                        <td class="actions">
                            <?php if (!$item['is_dir']): ?>
                                <a href="?download&file=<?php echo urlencode($item['name']); ?>&dir=<?php echo urlencode($relative_current_dir); ?>" class="btn">Download</a>
                                <button class="btn" onclick="editFile('<?php echo urlencode($item['name']); ?>')">Edit</button>
                                <button class="btn" onclick="renameFile('<?php echo urlencode($item['name']); ?>')">Rename</button>
                            <?php endif; ?>
                            <button class="btn btn-danger" onclick="deleteFile('<?php echo urlencode($item['name']); ?>', <?php echo $item['is_dir'] ? 'true' : 'false'; ?>)">Delete</button>
                        </td>
                    </tr>
                    <?php endforeach; ?>
                </tbody>
            </table>
        </div>
    </div>

    <div id="uploadModal" class="modal">
        <div class="modal-content">
            <h3>Upload File</h3>
            <form method="post" enctype="multipart/form-data">
                <div class="form-group">
                    <input type="file" name="file" required>
                </div>
                <button type="submit" name="upload" class="btn">Upload</button>
                <button type="button" class="btn" onclick="hideModal('uploadModal')">Cancel</button>
            </form>
        </div>
    </div>

    <div id="folderModal" class="modal">
        <div class="modal-content">
            <h3>Create Folder</h3>
            <form method="post">
                <div class="form-group">
                    <label>Folder Name:</label>
                    <input type="text" name="folder_name" required>
                </div>
                <button type="submit" name="create_folder" class="btn">Create</button>
                <button type="button" class="btn" onclick="hideModal('folderModal')">Cancel</button>
            </form>
        </div>
    </div>

    <div id="renameModal" class="modal">
        <div class="modal-content">
            <h3>Rename File/Folder</h3>
            <form method="post">
                <input type="hidden" name="old_name" id="old_name">
                <div class="form-group">
                    <label>New Name:</label>
                    <input type="text" name="new_name" id="new_name" required>
                </div>
                <button type="submit" name="rename" class="btn">Rename</button>
                <button type="button" class="btn" onclick="hideModal('renameModal')">Cancel</button>
            </form>
        </div>
    </div>

    <div id="editModal" class="modal">
        <div class="modal-content" style="max-width: 800px;">
            <h3>Edit File: <span id="edit_filename_display"></span></h3>
            <form method="post">
                <input type="hidden" name="file_path" id="file_path">
                <div class="form-group">
                    <textarea name="content" id="file_content" class="editor"></textarea>
                </div>
                <button type="submit" name="save_file" class="btn">Save</button>
                <button type="button" class="btn" onclick="hideModal('editModal')">Cancel</button>
            </form>
        </div>
    </div>

    <div id="deleteModal" class="modal">
        <div class="modal-content">
            <h3>Confirm Delete</h3>
            <p>Are you sure you want to delete <span id="delete_name_display"></span>?</p>
            <form method="post">
                <input type="hidden" name="file" id="delete_file">
                <button type="submit" name="delete" class="btn btn-danger">Delete</button>
                <button type="button" class="btn" onclick="hideModal('deleteModal')">Cancel</button>
            </form>
        </div>
    </div>

    <script>
        function showModal(modalId) {
            document.getElementById(modalId).style.display = 'block';
        }

        function hideModal(modalId) {
            document.getElementById(modalId).style.display = 'none';
        }

        function renameFile(filename) {
            var decodedFilename = decodeURIComponent(filename);
            document.getElementById('old_name').value = decodedFilename;
            document.getElementById('new_name').value = decodedFilename;
            showModal('renameModal');
        }

        function deleteFile(filename, is_dir) {
            var decodedFilename = decodeURIComponent(filename);
            document.getElementById('delete_file').value = decodedFilename;
            document.getElementById('delete_name_display').innerText = decodedFilename + (is_dir ? ' (Folder)' : ' (File)');
            showModal('deleteModal');
        }

        function editFile(filename) {
            var decodedFilename = decodeURIComponent(filename);
            document.getElementById('file_path').value = decodedFilename;
            document.getElementById('edit_filename_display').innerText = decodedFilename;
            
            // Dapatkan path relatif saat ini dari PHP
            var current_dir_param = '<?php echo urlencode($relative_current_dir); ?>';
            
            var xhr = new XMLHttpRequest();
            // PENTING: Panggil script dengan parameter 'ajax=load' dan 'dir'
            xhr.open('GET', '?ajax=load&file=' + encodeURIComponent(decodedFilename) + '&dir=' + current_dir_param, true); 
            xhr.onreadystatechange = function() {
                if (xhr.readyState === 4) {
                    if (xhr.status === 200) {
                        // Konten file berhasil dimuat
                        document.getElementById('file_content').value = xhr.responseText;
                        showModal('editModal');
                    } else {
                        // Tampilkan pesan error jika gagal (mungkin 404)
                        alert('Error loading file (' + xhr.status + '): ' + xhr.responseText);
                    }
                }
            };
            xhr.send();
        }

        // Close modal when clicking outside
        window.onclick = function(event) {
            if (event.target.className === 'modal') {
                event.target.style.display = 'none';
            }
        }
    </script>
</body>
</html>