<div class="aiz-sidebar-wrap">
    <div class="aiz-sidebar left c-scrollbar">

        <!-- Logo -->
        <div class="aiz-side-nav-logo-wrap">
            <a href="{{ route('admin.dashboard') }}" class="d-block">
                <img class="mw-100" src="{{ uploaded_asset(get_setting('system_logo_white')) }}" class="brand-icon"
                    alt="{{ get_setting('site_name') }}" style="width: 174px; height: 73px;">
            </a>
        </div>

        <div class="aiz-side-nav-wrap">
            <ul class="aiz-side-nav-list" data-toggle="aiz-side-menu">

                <!-- Dashboard -->
                <li class="aiz-side-nav-item">
                    <a href="{{ route('admin.dashboard') }}" class="aiz-side-nav-link">
                        <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 16 16">
                            <path id="Path_18917" data-name="Path 18917"
                                d="M3.889,11.889H9.222A.892.892,0,0,0,10.111,11V3.889A.892.892,0,0,0,9.222,3H3.889A.892.892,0,0,0,3,3.889V11A.892.892,0,0,0,3.889,11.889Zm0,7.111H9.222a.892.892,0,0,0,.889-.889V14.556a.892.892,0,0,0-.889-.889H3.889A.892.892,0,0,0,3,14.556v3.556A.892.892,0,0,0,3.889,19Zm8.889,0h5.333A.892.892,0,0,0,19,18.111V11a.892.892,0,0,0-.889-.889H12.778a.892.892,0,0,0-.889.889v7.111A.892.892,0,0,0,12.778,19ZM11.889,3.889V7.444a.892.892,0,0,0,.889.889h5.333A.892.892,0,0,0,19,7.444V3.889A.892.892,0,0,0,18.111,3H12.778A.892.892,0,0,0,11.889,3.889Z"
                                transform="translate(-3 -3)" fill="#707070" />
                        </svg>
                        <span class="aiz-side-nav-text">{{ translate('Dashboard') }}</span>
                    </a>
                </li>

                <!-- Product -->
                @canany(['show_products', 'show_seller_products', 'show_categories', 'show_brands', 'show_attributes',
                    'show_reviews', 'product_bulk_import', 'product_bulk_export'])
                    <li class="aiz-side-nav-item">
                        <a href="#" class="aiz-side-nav-link">
                            <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 16 16">
                                <g id="Group_23" data-name="Group 23" transform="translate(-126 -590)">
                                    <path id="Subtraction_31" data-name="Subtraction 31"
                                        d="M15,16H1a1,1,0,0,1-1-1V1A1,1,0,0,1,1,0H4.8V4.4a2,2,0,0,0,2,2H9.2a2,2,0,0,0,2-2V0H15a1,1,0,0,1,1,1V15A1,1,0,0,1,15,16Z"
                                        transform="translate(126 590)" fill="#707070" />
                                    <path id="Rectangle_93" data-name="Rectangle 93"
                                        d="M0,0H4A0,0,0,0,1,4,0V4A1,1,0,0,1,3,5H1A1,1,0,0,1,0,4V0A0,0,0,0,1,0,0Z"
                                        transform="translate(132 590)" fill="#707070" />
                                </g>
                            </svg>
                            <span class="aiz-side-nav-text">{{ translate('Product') }}</span>
                            <span class="aiz-side-nav-arrow"></span>
                        </a>
                        <ul class="aiz-side-nav-list level-2">
                            @can('show_products')
                                <li class="aiz-side-nav-item">
                                    <a href="{{ route('product.index') }}"
                                        class="aiz-side-nav-link {{ areActiveRoutes(['product.index', 'product.create', 'product.edit', 'product_bulk_upload.index']) }}">
                                        <span class="aiz-side-nav-text">{{ translate('Products') }}</span>
                                    </a>
                                </li>
                            @endcan
                        </ul>
                    </li>
                @endcanany

                <!-- Order -->
                @if (auth()->user()->can('show_orders') || auth()->user()->can('show_seller_orders'))
                    <li class="aiz-side-nav-item">
                        <a href="#" class="aiz-side-nav-link">
                            <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 16 16">
                                <path id="Subtraction_32" data-name="Subtraction 32"
                                    d="M15,16H1a1,1,0,0,1-1-1V1A1,1,0,0,1,1,0H15a1,1,0,0,1,1,1V15A1,1,0,0,1,15,16ZM7,11a1,1,0,1,0,0,2h6a1,1,0,0,0,0-2ZM3,11a1,1,0,1,0,1,1A1,1,0,0,0,3,11ZM7,7A1,1,0,1,0,7,9h6a1,1,0,0,0,0-2ZM3,7A1,1,0,1,0,4,8,1,1,0,0,0,3,7ZM7,3A1,1,0,1,0,7,5h6a1,1,0,0,0,0-2ZM3,3A1,1,0,1,0,4,4,1,1,0,0,0,3,3Z"
                                    fill="#707070" />
                            </svg>
                            <span class="aiz-side-nav-text">{{ translate('Orders') }}</span>
                            <span class="aiz-side-nav-arrow"></span>
                        </a>
                        <ul class="aiz-side-nav-list level-2">
                            @can('show_orders')
                                <li class="aiz-side-nav-item">
                                    <a href="{{ route('orders.index') }}"
                                        class="aiz-side-nav-link {{ areActiveRoutes(['orders.index', 'orders.show']) }}">
                                        <span class="aiz-side-nav-text">{{ translate('Orders') }}</span>
                                    </a>
                                </li>
                            @endcan
                            @can('show_seller_orders')
                                <li class="aiz-side-nav-item">
                                    <a href="{{ route('admin.seller_orders') }}" class="aiz-side-nav-link">
                                        <span class="aiz-side-nav-text">{{ translate('Seller Orders') }}</span>
                                        @if (env('DEMO_MODE') == 'On')
                                            <span class="badge badge-inline badge-danger">Addon</span>
                                        @endif
                                    </a>
                                </li>
                            @endcan
                        </ul>
                    </li>
                @elseif(auth()->user()->can('show_orders'))
                    @can('show_orders')
                        <li class="aiz-side-nav-item">
                            <a href="{{ route('orders.index') }}"
                                class="aiz-side-nav-link {{ areActiveRoutes(['orders.index', 'orders.show']) }}">
                                <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 16 16">
                                    <path id="Subtraction_32" data-name="Subtraction 32"
                                        d="M15,16H1a1,1,0,0,1-1-1V1A1,1,0,0,1,1,0H15a1,1,0,0,1,1,1V15A1,1,0,0,1,15,16ZM7,11a1,1,0,1,0,0,2h6a1,1,0,0,0,0-2ZM3,11a1,1,0,1,0,1,1A1,1,0,0,0,3,11ZM7,7A1,1,0,1,0,7,9h6a1,1,0,0,0,0-2ZM3,7A1,1,0,1,0,4,8,1,1,0,0,0,3,7ZM7,3A1,1,0,1,0,7,5h6a1,1,0,0,0,0-2ZM3,3A1,1,0,1,0,4,4,1,1,0,0,0,3,3Z"
                                        fill="#707070" />
                                </svg>
                                <span class="aiz-side-nav-text">{{ translate('Orders') }}</span>
                            </a>
                        </li>
                    @endcan
                @endif

                <!-- Seller -->
                @canany(['show_sellers', 'show_payouts', 'show_payout_requests', 'show_commission_log',
                    'show_seller_packages', 'show_seller_package_payments', 'seller_verification_form'])
                    <li class="aiz-side-nav-item">
                        <a href="#" class="aiz-side-nav-link">
                            <svg xmlns="http://www.w3.org/2000/svg" width="14" height="12.444" viewBox="0 0 14 12.444">
                                <path id="Path_25490" data-name="Path 25490"
                                    d="M4.985,6.083,5.6,2H2.4L1.063,5.5A1.227,1.227,0,0,0,1,5.889,1.82,1.82,0,0,0,3,7.444,1.9,1.9,0,0,0,4.985,6.083ZM8,7.444a1.82,1.82,0,0,0,2-1.556c0-.032,0-.064,0-.094L9.6,2H6.4L6,5.792c0,.032,0,.064,0,.1A1.82,1.82,0,0,0,8,7.444Zm3.889.814v3.075H4.111V8.263A3.273,3.273,0,0,1,3,8.456a3.206,3.206,0,0,1-.444-.038v4.938a1.091,1.091,0,0,0,1.087,1.089h8.713a1.093,1.093,0,0,0,1.089-1.089V8.418A3.342,3.342,0,0,1,13,8.456,3.232,3.232,0,0,1,11.889,8.258ZM14.938,5.5,13.6,2H10.4l.614,4.077A1.893,1.893,0,0,0,13,7.444a1.82,1.82,0,0,0,2-1.556A1.249,1.249,0,0,0,14.938,5.5Z"
                                    transform="translate(-1 -2)" fill="#707070" />
                            </svg>
                            <span class="aiz-side-nav-text">{{ translate('Seller') }}</span>
                            @if (env('DEMO_MODE') == 'On')
                                <span class="badge badge-inline badge-danger">Addon</span>
                            @endif
                            <span class="aiz-side-nav-arrow"></span>
                        </a>
                        <ul class="aiz-side-nav-list level-2">
                            @php
                                $sellers = \App\Models\Shop::where('verification_status', 0)
                                    ->where('verification_info', '!=', null)
                                    ->count();
                            @endphp
                            @can('show_sellers')
                                <li class="aiz-side-nav-item">
                                    <a href="{{ route('admin.all_sellers') }}"
                                        class="aiz-side-nav-link {{ areActiveRoutes(['admin.seller.create', 'admin.seller.edit']) }}">
                                        <span class="aiz-side-nav-text">{{ translate('Sellers') }}</span>
                                    </a>
                                </li>
                            @endcan
                            @can('show_payouts')
                                <li class="aiz-side-nav-item">
                                    <a href="{{ route('admin.seller_payments_history') }}" class="aiz-side-nav-link">
                                        <span class="aiz-side-nav-text">{{ translate('Payouts') }}</span>
                                    </a>
                                </li>
                            @endcan
                            @can('show_payout_requests')
                                <li class="aiz-side-nav-item">
                                    <a href="{{ route('admin.all_payout_requests') }}" class="aiz-side-nav-link">
                                        <span class="aiz-side-nav-text">{{ translate('Payout Requests') }}</span>
                                    </a>
                                </li>
                            @endcan
                            @can('show_commission_log')
                                <li class="aiz-side-nav-item">
                                    <a href="{{ route('admin.commission_log.index') }}" class="aiz-side-nav-link">
                                        <span class="aiz-side-nav-text">{{ translate('Earning History') }}</span>
                                    </a>
                                </li>
                            @endcan
                            @can('show_seller_packages')
                                <li class="aiz-side-nav-item">
                                    <a href="{{ route('admin.seller_packages.index') }}"
                                        class="aiz-side-nav-link {{ areActiveRoutes(['admin.seller_packages.create', 'admin.seller_packages.edit']) }}">
                                        <span class="aiz-side-nav-text">{{ translate('Seller Packages') }}</span>
                                    </a>
                                </li>
                            @endcan
                            @can('show_seller_package_payments')
                                <li class="aiz-side-nav-item">
                                    <a href="{{ route('admin.package_purchase_history') }}" class="aiz-side-nav-link">
                                        <span class="aiz-side-nav-text">{{ translate('Package Payments') }}</span>
                                    </a>
                                </li>
                            @endcan
                        </ul>
                    </li>
                @endcanany

                <!-- Location & Shipping -->
                @can('shipping_configuration')
                    <li class="aiz-side-nav-item">
                        <a href="javascript:void(0);" class="aiz-side-nav-link">
                            <svg fill="#707070" width="16px" height="16px" viewBox="0 0 24 24"
                                xmlns="http://www.w3.org/2000/svg" stroke="#707070">
                                <path
                                    d="M20.276,2.553,22,6H2L3.724,2.553A1,1,0,0,1,4.618,2H19.382A1,1,0,0,1,20.276,2.553ZM2,8H22V21a1,1,0,0,1-1,1H3a1,1,0,0,1-1-1Zm6.293,7.206a1,1,0,0,0,1.414,0L11,13.913V18.5a1,1,0,0,0,2,0V13.913l1.293,1.293a1,1,0,0,0,1.414-1.414l-3-3a1,1,0,0,0-1.414,0l-3,3A1,1,0,0,0,8.293,15.206Z" />
                            </svg>
                            <span class="aiz-side-nav-text">{{ translate('Location & Shipping') }}</span>
                            <span class="aiz-side-nav-arrow"></span>
                        </a>

                        <ul class="aiz-side-nav-list level-2">
                            <li class="aiz-side-nav-item">
                                <a href="{{ route('regions.index') }}"
                                    class="aiz-side-nav-link {{ areActiveRoutes(['regions.index', 'regions.edit', 'regions.update']) }}">
                                    <span class="aiz-side-nav-text">{{ translate('Regions') }}</span>
                                </a>
                            </li>
                            <li class="aiz-side-nav-item">
                                <a href="{{ route('states.index') }}"
                                    class="aiz-side-nav-link {{ areActiveRoutes(['states.index', 'states.edit', 'states.update']) }}">
                                    <span class="aiz-side-nav-text">{{ translate('Provinces') }}</span>
                                </a>
                            </li>
                            <li class="aiz-side-nav-item">
                                <a href="{{ route('cities.index') }}"
                                    class="aiz-side-nav-link {{ areActiveRoutes(['cities.index', 'cities.edit', 'cities.update']) }}">
                                    <span class="aiz-side-nav-text">{{ translate('Cities') }}</span>
                                </a>
                            </li>
                            <li class="aiz-side-nav-item">
                                <a href="{{ route('barangays.index') }}"
                                    class="aiz-side-nav-link {{ areActiveRoutes(['barangays.index']) }}">
                                    <span class="aiz-side-nav-text">{{ translate('Barangays') }}</span>
                                </a>
                            </li>
                            <li class="aiz-side-nav-item">
                                <a href="{{ route('zones.index') }}"
                                    class="aiz-side-nav-link {{ areActiveRoutes(['zones.index', 'zones.create', 'zones.edit', 'zones.update']) }}">
                                    <span class="aiz-side-nav-text">{{ translate('Shipping Zones & Rates') }}</span>
                                </a>
                            </li>
                        </ul>
                    </li>
                @endcan

                <!-- Payment method -->
                @can('payment_method')
                    <li class="aiz-side-nav-item">
                        <a href="{{ route('manual_payment_methods.index') }}" class="aiz-side-nav-link">
                            <svg id="Group_8930" data-name="Group 8930" xmlns="http://www.w3.org/2000/svg"
                                xmlns:xlink="http://www.w3.org/1999/xlink" width="16" height="16"
                                viewBox="0 0 16 16">
                                <defs>
                                    <clipPath id="clip-path">
                                        <rect id="Rectangle_17178" data-name="Rectangle 17178" width="16"
                                            height="16" fill="#707070" />
                                    </clipPath>
                                </defs>
                                <g id="Group_23708" data-name="Group 23708" clip-path="url(#clip-path)">
                                    <path id="Subtraction_80" data-name="Subtraction 80"
                                        d="M-30-647a5.006,5.006,0,0,1-5-5,5.006,5.006,0,0,1,5-5,5.006,5.006,0,0,1,5,5A5.005,5.005,0,0,1-30-647Zm-1.637-3.979v.409a1.025,1.025,0,0,0,1.023,1.024h.191v.614h.819v-.614h.219a1.025,1.025,0,0,0,1.023-1.024v-.819a1.024,1.024,0,0,0-1.023-1.023h-1.229a.2.2,0,0,1-.2-.205v-.819a.2.2,0,0,1,.2-.2h1.229a.2.2,0,0,1,.205.2v.41h.818v-.41a1.024,1.024,0,0,0-1.023-1.023H-29.6v-.615h-.819v.615h-.191a1.024,1.024,0,0,0-1.023,1.023v.819a1.025,1.025,0,0,0,1.023,1.024h1.229a.205.205,0,0,1,.205.2v.819a.205.205,0,0,1-.205.205h-1.229a.2.2,0,0,1-.2-.205v-.409Z"
                                        transform="translate(38 660)" fill="#707070" />
                                    <path id="Path_26789" data-name="Path 26789"
                                        d="M14.378,3.171H16V1.891H12.18V4.732h1.28V4.085a6.718,6.718,0,1,1-2.691-2.206L11.3.713a8,8,0,1,0,3.082,2.459"
                                        transform="translate(0 0)" fill="#707070" />
                                </g>
                            </svg>
                            <span class="aiz-side-nav-text">{{ translate('Payment Methods') }}</span>
                        </a>
                    </li>
                @endcan

                <!-- Users (no merchants) -->
                @canany(['show_staffs', 'show_staff_roles'])
                    <li class="aiz-side-nav-item">
                        <a href="#" class="aiz-side-nav-link">
                            <svg xmlns="http://www.w3.org/2000/svg" width="14" height="16.001"
                                viewBox="0 0 14 16.001">
                                <g id="Group_8868" data-name="Group 8868" transform="translate(30 -384)">
                                    <rect id="Rectangle_16229" data-name="Rectangle 16229" width="8" height="8"
                                        rx="4" transform="translate(-27 384)" fill="#707070" />
                                    <path id="Subtraction_35" data-name="Subtraction 35"
                                        d="M6,7H1A1,1,0,0,1,0,6,6.007,6.007,0,0,1,6,0H8a6.007,6.007,0,0,1,6,6,1,1,0,0,1-1,1H8V3A1,1,0,1,0,6,3V7Z"
                                        transform="translate(-30 393)" fill="#707070" />
                                </g>
                            </svg>
                            <span class="aiz-side-nav-text">{{ translate('Users') }}</span>
                            <span class="aiz-side-nav-arrow"></span>
                        </a>
                        <ul class="aiz-side-nav-list level-2">
                            @can('show_staffs')
                                <li class="aiz-side-nav-item">
                                    <a href="{{ route('staffs.index') }}"
                                        class="aiz-side-nav-link {{ areActiveRoutes(['staffs.index', 'staffs.create', 'staffs.edit']) }}">
                                        <span class="aiz-side-nav-text">{{ translate('Staffs') }}</span>
                                    </a>
                                </li>
                            @endcan
                            @can('show_staff_roles')
                                <li class="aiz-side-nav-item">
                                    <a href="{{ route('roles.index') }}"
                                        class="aiz-side-nav-link {{ areActiveRoutes(['roles.index', 'roles.create', 'roles.edit']) }}">
                                        <span class="aiz-side-nav-text">{{ translate('Roles') }}</span>
                                    </a>
                                </li>
                            @endcan
                        </ul>
                    </li>
                @endcanany

                <!-- product query -->
                @if (addon_is_activated('multi_vendor') &&
                        get_setting('conversation_system') == 1 &&
                        auth()->user()->can('product_query'))
                    @php
                        $conversation = \App\Models\Conversation::where('receiver_id', Auth::user()->id)
                            ->where('receiver_viewed', 0)
                            ->get();
                    @endphp
                    <li class="aiz-side-nav-item">
                        <a href="{{ route('querries.index') }}"
                            class="aiz-side-nav-link {{ areActiveRoutes(['querries.index', 'querries.show']) }}">
                            <svg xmlns="http://www.w3.org/2000/svg" width="16.499" height="15.527"
                                viewBox="0 0 16.499 15.527">
                                <g id="Group_23439" data-name="Group 23439" transform="translate(12740.499 6159.76)">
                                    <path id="Path_28783" data-name="Path 28783"
                                        d="M208.917.891a.859.859,0,0,0-.207-.585A.956.956,0,0,0,207.937,0q-2.627,0-5.254,0a.9.9,0,0,0-1,1q0,1.2,0,2.408c0,.407-.006.814,0,1.22a.88.88,0,0,0,.858.9c.124.01.249,0,.4,0,0,.283-.009.543.005.8,0,.077.06.2.116.213a.277.277,0,0,0,.219-.108c.2-.256.389-.521.574-.788a.242.242,0,0,1,.228-.115c.569,0,1.139,0,1.708,0,.721,0,1.442,0,2.163,0a.9.9,0,0,0,.952-.932c0-1.236,0-2.473,0-3.709m-5.361,2.374a.633.633,0,1,1,0-1.267.609.609,0,0,1,.628.639.609.609,0,0,1-.624.627m1.721,0A.633.633,0,0,1,205.285,2a.637.637,0,0,1,.632.633.619.619,0,0,1-.64.634m1.759,0A.633.633,0,0,1,207.058,2a.618.618,0,0,1,.626.632.639.639,0,0,1-.648.634"
                                        transform="translate(-12932.919 -6159.76)" fill="#707070" />
                                    <rect id="Rectangle_17258" data-name="Rectangle 17258" width="2.48"
                                        height="2.875" transform="translate(-12734.919 -6156.351)" fill="#707070" />
                                    <path id="Union_63" data-name="Union 63"
                                        d="M1.375,11.628A1.3,1.3,0,0,1,0,10.25Q0,5.817,0,1.384A1.308,1.308,0,0,1,1.39,0H4.737V3.222H7.863V.009H8.43c0,.365,0,.721,0,1.078a1.7,1.7,0,0,0,.043.418,1.189,1.189,0,0,0,.994.909c.069.013.139.02.227.033,0,.154,0,.31,0,.466a.506.506,0,0,0,.932.314c.178-.232.351-.469.533-.7a.238.238,0,0,1,.154-.089c.417-.007.834,0,1.271,0,0,.064.008.121.008.177q0,3.815,0,7.63a1.292,1.292,0,0,1-1.379,1.385H1.375Zm4.448-1.449V6.942h0v3.237a.309.309,0,0,1-.083.016A.309.309,0,0,0,5.824,10.179Zm-4.377.009h0V6.946h0Zm5.594,0V6.943h0Zm-.384,0V6.94h0v3.246Zm-2.781,0V6.942h0Zm4.231,0V6.94h0Zm-4.895,0h0V6.941h0Zm1.4,0V6.942h0Zm-2.4,0h0V6.938h0Zm3.452-.08q0-.009,0-.02Q5.664,10.093,5.664,10.1ZM5.666,7q0,1.543,0,3.085,0-1.543,0-3.085Z"
                                        transform="translate(-12740 -6156.362)" fill="#707070" stroke="rgba(0,0,0,0)"
                                        stroke-miterlimit="10" stroke-width="1" />
                                </g>
                            </svg>
                            <span class="aiz-side-nav-text">{{ translate('Product Querries') }}</span>
                            @if (count($conversation) > 0)
                                <span class="badge badge-inline badge-danger p-2">({{ count($conversation) }})</span>
                            @endif
                        </a>
                    </li>
                @endif
                <!-- /product query -->

                <!-- Affiliate System -->
                @if (get_setting('affiliate_system') == 1)
                    <li class="aiz-side-nav-item">
                        <a href="#" class="aiz-side-nav-link">
                            <svg id="Group_23794" data-name="Group 23794" xmlns="http://www.w3.org/2000/svg"
                                xmlns:xlink="http://www.w3.org/1999/xlink" width="15.774" height="16"
                                viewBox="0 0 15.774 16">
                                <defs>
                                    <clipPath id="clip-path">
                                        <rect id="Rectangle_17810" data-name="Rectangle 17810" width="15.774"
                                            height="16" fill="#707070" />
                                    </clipPath>
                                </defs>
                                <g id="Group_23782" data-name="Group 23782" clip-path="url(#clip-path)">
                                    <path id="Path_27903"
                                        d="M135.768,0a9.26,9.26,0,0,1,.939.215,3.942,3.942,0,1,1-1.838-.176c.071-.011.141-.026.211-.039Zm.143,6.3a3.566,3.566,0,0,0,.361-.161,1.24,1.24,0,0,0,.072-2.1c-.416-.312-.837-.619-1.255-.928a.307.307,0,0,1,.181-.575c.109,0,.219,0,.328,0a.314.314,0,0,1,.351.316.473.473,0,0,0,.511.453.484.484,0,0,0,.417-.575,1.236,1.236,0,0,0-.868-1.079.183.183,0,0,1-.1-.121c-.039-.295-.2-.471-.46-.475a.476.476,0,0,0-.484.47.183.183,0,0,1-.1.125A1.211,1.211,0,0,0,134,2.683a1.209,1.209,0,0,0,.535,1.189l1.217.9c.175.129.226.244.175.392s-.159.208-.377.209h-.266a.313.313,0,0,1-.361-.319.465.465,0,0,0-.506-.44.472.472,0,0,0-.429.519,1.23,1.23,0,0,0,.815,1.1.206.206,0,0,1,.172.209.453.453,0,0,0,.464.417.467.707070,0,0,0,.459-.443c0-.041.006-.082.009-.118"
                                        transform="translate(-126.005)" fill="#707070" />
                                    <path id="Path_27904"
                                        d="M2.575,244.87a.79.79,0,0,1-.341-.346q-1.057-1.84-2.121-3.677a.465.465,0,0,1,.2-.75l2.04-1.178a.45.45,0,0,1,.706.188q1.089,1.885,2.177,3.771a.448.448,0,0,1-.182.7q-1.127.651-2.258,1.3Z"
                                        transform="translate(0 -228.87)" fill="#707070" />
                                    <path id="Path_27905"
                                        d="M103.993,209.048c-.62,0-1.239,0-1.859,0a.193.193,0,0,1-.2-.111q-.889-1.55-1.788-3.095a.207.207,0,0,1,0-.241,3.232,3.232,0,0,1,2.387-1.585,2.919,2.919,0,0,1,2.53.836.307.307,0,0,0,.192.068c.562.005,1.125,0,1.687,0a.622.622,0,1,1-.006,1.243c-.781,0-1.562,0-2.343,0a.465.465,0,0,0-.453.643.444.444,0,0,0,.425.291c.781,0,1.562.008,2.343,0a1.584,1.584,0,0,0,.914-.322q1.4-1.011,2.8-2.022a.678.678,0,0,1,.616-.129.613.613,0,0,1,.455.488.639.639,0,0,1-.269.685q-.63.461-1.262.919c-.722.521-1.441,1.046-2.169,1.558a4.14,4.14,0,0,1-2.538.772c-.489-.011-.979,0-1.469,0"
                                        transform="translate(-95.942 -195.483)" fill="#707070" />
                                </g>
                            </svg>
                            <span class="aiz-side-nav-text">{{ translate('Affiliate System') }}</span>
                            @if (env('DEMO_MODE') == 'On')
                                <span class="badge badge-inline badge-danger">Addon</span>
                            @endif
                            <span class="aiz-side-nav-arrow"></span>
                        </a>
                        <ul class="aiz-side-nav-list level-2">
                            <li class="aiz-side-nav-item">
                                <a href="{{ route('affiliate.configs') }}" class="aiz-side-nav-link">
                                    <span class="aiz-side-nav-text">{{ translate('Affiliate Configurations') }}</span>
                                </a>
                            </li>
                            <li class="aiz-side-nav-item">
                                <a href="{{ route('affiliate.users') }}"
                                    class="aiz-side-nav-link {{ areActiveRoutes(['affiliate_users.show_verification_info']) }}">
                                    <span class="aiz-side-nav-text">{{ translate('Affiliate Users') }}</span>
                                </a>
                            </li>
                            <li class="aiz-side-nav-item">
                                <a href="{{ route('refferal.users') }}" class="aiz-side-nav-link">
                                    <span class="aiz-side-nav-text">{{ translate('Referral Users') }}</span>
                                </a>
                            </li>
                            <li class="aiz-side-nav-item">
                                <a href="{{ route('affiliate.withdraw_requests') }}" class="aiz-side-nav-link">
                                    <span
                                        class="aiz-side-nav-text">{{ translate('Affiliate Withdraw Requests') }}</span>
                                </a>
                            </li>
                            <li class="aiz-side-nav-item">
                                <a href="{{ route('affiliate.logs') }}" class="aiz-side-nav-link">
                                    <span class="aiz-side-nav-text">{{ translate('Affiliate Logs') }}</span>
                                </a>
                            </li>
                        </ul>
                    </li>
                @endif

                <!-- Club Point System -->
                @if (get_setting('club_point'))
                    <li class="aiz-side-nav-item">
                        <a href="#" class="aiz-side-nav-link">
                            <svg id="Group_22520" data-name="Group 22520" xmlns="http://www.w3.org/2000/svg"
                                xmlns:xlink="http://www.w3.org/1999/xlink" width="16.99" height="16"
                                viewBox="0 0 16.99 16">
                                <defs>
                                    <clipPath id="clip-path">
                                        <rect id="Rectangle_1413" data-name="Rectangle 1413" width="16.991"
                                            height="16" fill="#707070" />
                                    </clipPath>
                                </defs>
                                <g id="Group_22519" data-name="Group 22519" clip-path="url(#clip-path)">
                                    <path id="Path_27921"
                                        d="M10.3,117.626a5.152,5.152,0,1,1-4.917-5.279,5.154,5.154,0,0,1,4.917,5.279m-4.844-2.388c0-.071,0-.152,0-.234s0-.165,0-.246a.3.3,0,0,0-.307-.3.3.3,0,0,0-.3.307,3.5,3.5,0,0,0,0,.36c.005.1-.03.134-.125.17a2.422,2.422,0,0,0-.606.3,1.135,1.135,0,0,0,.034,1.884,1.669,1.669,0,0,0,.993.319,1.049,1.049,0,0,1,.684.233.53.53,0,0,1-.014.887,1.077,1.077,0,0,1-1.179.1.639.639,0,0,1-.4-.555.3.3,0,1,0-.6.041,1.133,1.133,0,0,0,.777,1.068c.356.127.5.289.441.66a.276.276,0,0,0,.3.3.3.3,0,0,0,.3-.286.943.943,0,0,0,0-.227c-.028-.2.02-.329.251-.362a.963.963,0,0,0,.342-.155,1.162,1.162,0,0,0,.007-2.05,2,2,0,0,0-.879-.262,1.59,1.59,0,0,1-.624-.177.543.543,0,0,1,0-.982A1.088,1.088,0,0,1,5.717,116a.639.639,0,0,1,.35.529.3.3,0,0,0,.437.255.327.327,0,0,0,.161-.372,1.238,1.238,0,0,0-.689-.961,5.239,5.239,0,0,0-.519-.212"
                                        transform="translate(0 -106.65)" fill="#707070" />
                                    <path id="Path_27922"
                                        d="M153.3,53.949c0,.54.005,1.081-.007,1.622,0,.065-.088.146-.155.188a4.946,4.946,0,0,1-1.6.6,13.584,13.584,0,0,1-5.454.138.311.311,0,0,0-.4.217.3.3,0,0,0,.276.374,12.975,12.975,0,0,0,3.131.209,12.576,12.576,0,0,0,3.225-.52c.329-.1.646-.243.989-.373v.2c0,1.232-.006,2.464.006,3.7a.43.43,0,0,1-.257.456,10.081,10.081,0,0,1-1.317.512,13.242,13.242,0,0,1-4.4.34.508.508,0,0,1-.068-.01l-.481-1.9c.192.015.42.033.647.049a13.885,13.885,0,0,0,3.454-.171c.237-.043.345-.156.333-.338s-.165-.292-.4-.268c-.671.071-1.342.18-2.015.191-.749.012-1.5-.069-2.249-.109a.36.36,0,0,1-.3-.184,5.643,5.643,0,0,0-2.5-2.1c-.086-.037-.164-.06-.162-.193.008-.859,0-1.719,0-2.578a.331.331,0,0,1,.012-.059,5.839,5.839,0,0,0,3.279,1.12,13.6,13.6,0,0,0,4.076-.139,5.737,5.737,0,0,0,1.687-.545c.224-.121.427-.28.653-.431"
                                        transform="translate(-136.315 -51.21)" fill="#707070" />
                                </g>
                            </svg>
                            <span class="aiz-side-nav-text">{{ translate('Club Point System') }}</span>
                            <span class="aiz-side-nav-arrow"></span>
                        </a>
                        <ul class="aiz-side-nav-list level-2">
                            <li class="aiz-side-nav-item">
                                <a href="{{ route('club_points.configs') }}"
                                    class="aiz-side-nav-link {{ areActiveRoutes(['product_club_point.edit']) }}">
                                    <span
                                        class="aiz-side-nav-text">{{ translate('Club Point Configurations') }}</span>
                                </a>
                            </li>
                            <li class="aiz-side-nav-item">
                                <a href="{{ route('club_points.index') }}"
                                    class="aiz-side-nav-link {{ areActiveRoutes(['club_points.index', 'club_point.details']) }}">
                                    <span class="aiz-side-nav-text">{{ translate('User Points') }}</span>
                                </a>
                            </li>
                        </ul>
                    </li>
                @endif

                <!-- Setup & Configurations -->
                @canany(['show_shop_setting', 'show_general_setting', 'sms_settings', 'show_languages',
                    'show_currencies', 'payment_method', 'file_system', 'social_media_login', 'third_party_setting',
                    'show_taxes'])
                    <li class="aiz-side-nav-item">
                        <a href="{{ route('general_setting.index') }}" class="aiz-side-nav-link">
                            <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 16 16">
                                <g id="Group_8866" data-name="Group 8866" transform="translate(-3.185 -7)">
                                    <path id="Path_18928" data-name="Path 18928"
                                        d="M13.688,20.6a6.064,6.064,0,0,0,1.331-.768l-.033.048,1.68.624a.826.826,0,0,0,1.015-.352l1.4-2.336a.79.79,0,0,0-.2-1.024L17.464,15.7l-.033.048a6.021,6.021,0,0,0,.083-.768,6.021,6.021,0,0,0-.083-.768l.033.048,1.414-1.088a.79.79,0,0,0,.2-1.024l-1.4-2.336a.845.845,0,0,0-1.015-.352l-1.68.624.033.048A7.559,7.559,0,0,0,13.688,9.4l-.283-1.728A.8.8,0,0,0,12.591,7H9.8a.8.8,0,0,0-.815.672L8.7,9.4a6.064,6.064,0,0,0-1.331.768L7.4,10.12,5.7,9.5a.826.826,0,0,0-1.015.352l-1.4,2.336a.79.79,0,0,0,.2,1.024L4.906,14.3l.033-.048A5.485,5.485,0,0,0,4.856,15a6.021,6.021,0,0,0,.083.768l-.033-.048L3.493,16.808a.79.79,0,0,0-.2,1.024l1.4,2.336A.845.845,0,0,0,5.7,20.52l1.68-.624-.017-.064A6.065,6.065,0,0,0,8.7,20.6l.283,1.712A.8.8,0,0,0,9.8,23h2.794a.8.8,0,0,0,.815-.672ZM7.867,15a3.329,3.329,0,1,1,3.326,3.2A3.275,3.275,0,0,1,7.867,15Z"
                                        transform="translate(0)" fill="#707070" />
                                </g>
                            </svg>
                            <span class="aiz-side-nav-text">{{ translate('General Settings') }}</span>
                        </a>
                    </li>
                @endcanany

                @can('system_status')
                    <li class="aiz-side-nav-item">
                        <a href="{{ route('server_status') }}" class="aiz-side-nav-link">
                            <svg xmlns="http://www.w3.org/2000/svg" width="16" height="14" viewBox="0 0 16 14">
                                <g id="Group_8869" data-name="Group 8869" transform="translate(-24 -40)">
                                    <path id="Subtraction_36" data-name="Subtraction 36"
                                        d="M5-525H-9a1,1,0,0,1-1-1v-9a1,1,0,0,1,1-1H5a1,1,0,0,1,1,1v9A1,1,0,0,1,5-525Zm-5.476-9.5a2.5,2.5,0,0,0-1.76.725,2.5,2.5,0,0,0-.651,2.339L-5.624-528.7a1.3,1.3,0,0,0,0,1.825,1.291,1.291,0,0,0,.913.376,1.292,1.292,0,0,0,.912-.376l2.736-2.74a2.489,2.489,0,0,0,.585.07,2.5,2.5,0,0,0,1.754-.719,2.508,2.508,0,0,0,.6-2.541l-.653.653-.408.405a1.1,1.1,0,0,1-.783.325,1.1,1.1,0,0,1-.783-.325,1.1,1.1,0,0,1-.325-.785,1.1,1.1,0,0,1,.325-.782l.4-.408.653-.653a2.481,2.481,0,0,0-.78-.125Z"
                                        transform="translate(34 576)" fill="#707070" />
                                    <rect id="Rectangle_16228" data-name="Rectangle 16228" width="6" height="1"
                                        rx="0.5" transform="translate(29 53)" fill="#707070" />
                                </g>
                            </svg>
                            <span class="aiz-side-nav-text">{{ translate('System Status') }}</span>
                        </a>
                    </li>
                @endcan

            </ul><!-- .aiz-side-nav -->
        </div><!-- .aiz-side-nav-wrap -->
    </div><!-- .aiz-sidebar -->
    <div class="aiz-sidebar-overlay"></div>
</div><!-- .aiz-sidebar -->
