<!doctype html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}">

<head>
    <meta name="csrf-token" content="{{ csrf_token() }}">
    <meta name="app-url" content="{{ getBaseURL() }}">
    <meta name="file-base-url" content="{{ getFileBaseURL() }}">
    <meta http-equiv="refresh" content="{{ config('session.lifetime') * 60 }}">

    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">

    <link rel="icon" href="{{ static_asset('assets/img/favicon.ico') }}" type="image/x-icon">
    <title>{{ config('app.name', 'The Shop') }}</title>

    <!-- Fonts & CSS -->
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Roboto:wght@300;400;500;700;900&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="{{ static_asset('assets/css/vendors.css') }}">
    <link rel="stylesheet" href="{{ static_asset('assets/css/aiz-core.css') }}">

    <script>
        var AIZ = AIZ || {};
        AIZ.local = {
            nothing_selected: '{{ translate('Nothing selected') }}',
            nothing_found: '{{ translate('Nothing found') }}',
            choose_file: '{{ translate('Choose file') }}',
            file_selected: '{{ translate('File selected') }}',
            files_selected: '{{ translate('Files selected') }}',
            add_more_files: '{{ translate('Add more files') }}',
            adding_more_files: '{{ translate('Adding more files') }}',
            drop_files_here_paste_or: '{{ translate('Drop files here, paste or') }}',
            browse: '{{ translate('Browse') }}',
            upload_complete: '{{ translate('Upload complete') }}',
            upload_paused: '{{ translate('Upload paused') }}',
            resume_upload: '{{ translate('Resume upload') }}',
            pause_upload: '{{ translate('Pause upload') }}',
            retry_upload: '{{ translate('Retry upload') }}',
            cancel_upload: '{{ translate('Cancel upload') }}',
            uploading: '{{ translate('Uploading') }}',
            processing: '{{ translate('Processing') }}',
            complete: '{{ translate('Complete') }}',
            file: '{{ translate('File') }}',
            files: '{{ translate('Files') }}',
        }
    </script>

    <style>
        /* Page uses a flex column so footer can stick to bottom naturally */
        .aiz-main-content {
            min-height: 100vh;
            display: flex;
            flex-direction: column;
        }

        /* Center area: constrain width for large screens, full width on mobile */
        .aiz-centered-container {
            width: 100%;
            max-width: 720px;
            /* tweak as you like (600–840px is nice) */
        }

        /* Ensure no weird horizontal scroll on tiny screens */
        body {
            overflow-x: hidden;
        }
    </style>
</head>

<body class="min-vh-100 d-flex flex-column">

    <div class="aiz-main-content">
        <!-- MAIN (centered both axes) -->
        <main class="flex-grow-1 d-flex align-items-center justify-content-center py-5 px-3">
            <div class="aiz-centered-container w-100">
                @yield('content')
            </div>
        </main>

        <!-- FOOTER (sticky, non-fixed, won’t overlap content) -->
        <footer class="bg-white text-center py-3 px-3 mt-auto">
            <p class="mb-0">&copy; {{ get_setting('site_name') }} {{ date('Y') }}</p>
        </footer>
    </div><!-- .aiz-main-content -->

    @yield('modal')

    <script src="{{ static_asset('assets/js/vendors.js') }}"></script>
    <script src="{{ static_asset('assets/js/aiz-core.js') }}"></script>

    @yield('script')

    <script type="text/javascript">
        @foreach (session('flash_notification', collect())->toArray() as $message)
            AIZ.plugins.notify('{{ $message['level'] }}', '{{ $message['message'] }}');
        @endforeach
    </script>
</body>

</html>
