@extends('backend.layouts.app')

@section('content')
<div class="card">
    <form method="GET" action="{{ route('admin.merchant_earnings.index') }}">
        <div class="card-header row gutters-5">
            <div class="col text-center text-md-left">
                <h5 class="mb-0 h6">{{ translate('All Merchant Earnings') }}</h5>
                <small class="text-muted">
                    {{ translate('Commission Rate') }}: {{ rtrim(rtrim(number_format($commission_rate,2,'.',''), '0'), '.') }}%
                    ({{ translate('display only; computations use ledger') }})
                </small>
            </div>

            <div class="col-md-2">
                <input type="date" class="form-control form-control-sm" name="date_from" value="{{ $date_from }}">
            </div>
            <div class="col-md-2">
                <input type="date" class="form-control form-control-sm" name="date_to" value="{{ $date_to }}">
            </div>

            <div class="col-md-3">
                <input type="text" class="form-control form-control-sm" name="q" value="{{ $q }}"
                    placeholder="{{ translate('Search merchant, email, phone') }}">
            </div>

            <div class="col-auto">
                <button class="btn btn-sm btn-primary" type="submit">{{ translate('Filter') }}</button>
            </div>

            @can('merchant_earnings.export')
                <div class="col-auto">
                    <a href="{{ route('admin.merchant_earnings.export', request()->query()) }}"
                       class="btn btn-sm btn-soft-success">
                        {{ translate('Export CSV') }}
                    </a>
                </div>
            @endcan
        </div>
    </form>

    <div class="card-body">
        <table class="table aiz-table mb-0">
            <thead>
                <tr>
                    <th>#</th>
                    <th>{{ translate('Merchant') }}</th>
                    <th>{{ translate('Orders') }}</th>
                    <th class="text-right">{{ translate('Gross') }}</th>
                    <th class="text-right">{{ translate('Admin Commission') }}</th>
                    <th class="text-right">{{ translate('Merchant Net') }}</th>
                    <th class="text-right">{{ translate('Paid Payouts') }}</th>
                    <th class="text-right">{{ translate('Current Balance') }}</th>
                    <th class="text-right">{{ translate('Options') }}</th>
                </tr>
            </thead>
            <tbody>
                @forelse ($merchants as $i => $m)
                    <tr>
                        <td>{{ $i + 1 + ($merchants->currentPage() - 1) * $merchants->perPage() }}</td>
                        <td>
                            <div class="fw-600">{{ $m->name }}</div>
                            <div class="text-muted fs-12">{{ $m->email }} - {{ $m->phone }}</div>
                        </td>
                        <td>{{ (int) ($m->orders_count ?? 0) }}</td>
                        <td class="text-right">{{ format_price((float) ($m->gross_all ?? 0), true) }}</td>
                        <td class="text-right">{{ format_price((float) ($m->commission ?? 0), true) }}</td>
                        <td class="text-right">{{ format_price((float) ($m->merchant_net ?? 0), true) }}</td>
                        <td class="text-right">{{ format_price((float) ($m->paid_payouts ?? 0), true) }}</td>
                        <td class="text-right">{{ format_price((float) ($m->current_balance ?? 0), true) }}</td>
                        <td class="text-right">
                            <a class="btn btn-soft-info btn-sm"
                               href="{{ route('admin.merchant_earnings.show', $m->id) }}">{{ translate('View') }}</a>
                        </td>
                    </tr>
                @empty
                    <tr>
                        <td colspan="9" class="text-center text-muted">{{ translate('No data') }}</td>
                    </tr>
                @endforelse
            </tbody>
        </table>
        <div class="aiz-pagination">
            {{ $merchants->links() }}
        </div>
    </div>
</div>
@endsection
