@extends('backend.layouts.app')

@section('content')
<div class="card">
    <div class="card-header row gutters-5">
        <div class="col">
            <h5 class="mb-0 h6">{{ translate('Earnings for') }}: {{ $merchant->name }}</h5>
            <small class="text-muted">{{ $merchant->email }} - {{ $merchant->phone }}</small>
            <div>
                <small class="text-muted">
                    {{ translate('Commission Rate') }}:
                    {{ rtrim(rtrim(number_format($commission_rate,2,'.',''), '0'), '.') }}%
                    ({{ translate('display only; computations use ledger') }})
                </small>
            </div>
        </div>
        <form class="col-auto d-flex" method="GET" action="{{ route('admin.merchant_earnings.show', $merchant->id) }}">
            <input type="date" class="form-control form-control-sm mr-2" name="date_from" value="{{ $date_from }}">
            <input type="date" class="form-control form-control-sm mr-2" name="date_to" value="{{ $date_to }}">
            <button class="btn btn-sm btn-primary">{{ translate('Filter') }}</button>
        </form>
    </div>

    <div class="card-body">
        <div class="row mb-4">
            <div class="col-md-3">
                <div class="shadow-sm rounded p-3 bg-light">
                    <div class="fw-500">{{ translate('Gross') }}</div>
                    <div class="h5 fw-700 mb-0">{{ format_price((float) $gross_total, true) }}</div>
                </div>
            </div>
            <div class="col-md-3">
                <div class="shadow-sm rounded p-3 bg-light">
                    <div class="fw-500">{{ translate('Admin Commission') }}</div>
                    <div class="h5 fw-700 mb-0">{{ format_price((float) $admin_commission, true) }}</div>
                </div>
            </div>
            <div class="col-md-3">
                <div class="shadow-sm rounded p-3 bg-light">
                    <div class="fw-500">{{ translate('Merchant Net') }}</div>
                    <div class="h5 fw-700 mb-0">{{ format_price((float) $merchant_net_total, true) }}</div>
                </div>
            </div>
            <div class="col-md-3">
                <div class="shadow-sm rounded p-3 bg-light">
                    <div class="fw-500">{{ translate('Paid Payouts') }}</div>
                    <div class="h5 fw-700 mb-0">{{ format_price((float) $paid_payouts, true) }}</div>
                </div>
            </div>
        </div>

        <div class="row mb-4">
            <div class="col-md-3">
                <div class="shadow-sm rounded p-3" style="background:#D1F7C4">
                    <div class="fw-500">{{ translate('Current Balance') }}</div>
                    <div class="h5 fw-700 mb-0">{{ format_price((float) $current_balance, true) }}</div>
                </div>
            </div>
        </div>

        <table class="table aiz-table mb-0">
            <thead>
                <tr>
                    <th>{{ translate('Order #') }}</th>
                    <th>{{ translate('Date') }}</th>
                    <th class="text-right">{{ translate('Gross') }}</th>
                    <th class="text-right">{{ translate('Admin Commission') }}</th>
                    <th class="text-right">{{ translate('Merchant Net') }}</th>
                </tr>
            </thead>
            <tbody>
                @forelse ($details as $row)
                    <tr>
                        <td>{{ $row->order_code ?? $row->order_id }}</td>
                        <td>{{ \Carbon\Carbon::parse($row->created_at)->toDayDateTimeString() }}</td>
                        <td class="text-right">{{ format_price((float) $row->gross, true) }}</td>
                        <td class="text-right">{{ format_price((float) $row->commission, true) }}</td>
                        <td class="text-right">{{ format_price((float) $row->merchant_net, true) }}</td>
                    </tr>
                @empty
                    <tr>
                        <td colspan="5" class="text-center text-muted">{{ translate('No orders') }}</td>
                    </tr>
                @endforelse
            </tbody>
        </table>

        <div class="aiz-pagination">
            {{ $details->links() }}
        </div>
    </div>
</div>
@endsection
