@extends('backend.layouts.app')

@section('content')
    <div class="card">
        <form id="merchant_payouts_filter" method="GET">
            <div class="card-header row gutters-5 align-items-center">
                <div class="col text-center text-md-left">
                    <h5 class="mb-0 h6">{{ translate('Paid Payouts') }}</h5>
                </div>
                <div class="col-md-3 ml-auto">
                    <div class="input-group">
                        <input type="text" class="form-control form-control-sm aiz-date-range" name="date_range"
                            value="{{ $date_range }}" placeholder="{{ translate('Date range') }}" autocomplete="off"
                            data-format="YYYY-MM-DD" data-separator=" / ">
                        <div class="input-group-append">
                            <button type="submit" class="btn btn-sm btn-primary">{{ translate('Filter') }}</button>
                        </div>
                    </div>
                    <small class="text-muted d-block mt-1">
                        {{ translate('Shows only payouts marked as Paid') }}
                    </small>
                </div>
            </div>
        </form>

        <div class="card-body">
            <div class="table-responsive">
                <table class="table aiz-table mb-0">
                    <thead>
                        <tr>
                            <th>#</th>
                            <th>{{ translate('Amount') }}</th>
                            <th>{{ translate('Payment Method') }}</th>
                            <th>{{ translate('Date') }}</th>
                        </tr>
                    </thead>
                    <tbody>
                        @forelse ($payouts as $i => $payout)
                            <tr>
                                <td>{{ $payouts->firstItem() + $i }}</td>
                                <td>{{ format_price((float) ($payout->paid_amount ?? 0), true) }}</td>
                                <td class="text-nowrap">{{ ucfirst(str_replace('_', ' ', $payout->payment_method)) }}</td>
                                <td>{{ optional($payout->created_at)->toFormattedDateString() }}</td>
                            </tr>
                        @empty
                            <tr>
                                <td colspan="5" class="text-center text-muted">
                                    {{ translate('No paid payouts found for the selected range.') }}
                                </td>
                            </tr>
                        @endforelse
                    </tbody>
                </table>
            </div>

            <div class="aiz-pagination">
                {{ $payouts->appends(request()->input())->links() }}
            </div>
        </div>
    </div>
@endsection
