@extends('backend.layouts.app')

@section('content')
    <div class="aiz-titlebar mt-2 mb-4">
        <div class="row align-items-center">
            <div class="col-md-6">
                <h1 class="h3">{{ translate('Withdraw Settings') }}</h1>
            </div>
            <div class="col-md-6 text-md-right">
                <a href="{{ route('merchant.payouts.request') }}" class="btn btn-soft-primary btn-sm">
                    {{ translate('Back to Requests') }}
                </a>
            </div>
        </div>
    </div>

    <div class="row">
        <div class="col-md-8 mx-auto">
            <form action="{{ route('merchant.payout_settings.update') }}" method="POST">
                @csrf

                <div class="card">
                    <div class="card-header">
                        <h5 class="mb-0 h6">{{ translate('Payout Methods') }}</h5>
                    </div>

                    {{-- GCash --}}
                    <div class="card-body border-bottom">
                        <div class="row align-items-center mb-3">
                            <label class="col-md-3 col-form-label mb-0">{{ translate('GCash') }}</label>
                            <div class="col-md-9">
                                <label class="aiz-switch aiz-switch-success mb-0">
                                    <input type="checkbox" name="gcash_payout_status" value="1"
                                        @if ((int) ($user->gcash_payout_status ?? 0) === 1) checked @endif>
                                    <span class="slider round"></span>
                                </label>
                            </div>
                        </div>

                        <div class="row mb-3">
                            <label class="col-md-3 col-form-label">{{ translate('Account Name') }}</label>
                            <div class="col-md-9">
                                <input type="text" name="gcash_name" class="form-control"
                                    value="{{ old('gcash_name', $user->gcash_name ?? '') }}"
                                    placeholder="{{ translate('Juan Dela Cruz') }}">
                            </div>
                        </div>

                        <div class="row">
                            <label class="col-md-3 col-form-label">{{ translate('Mobile Number') }}</label>
                            <div class="col-md-9">
                                <input type="text" name="gcash_no" class="form-control"
                                    value="{{ old('gcash_no', $user->gcash_no ?? '') }}"
                                    placeholder="{{ translate('09XXXXXXXXX') }}">
                            </div>
                        </div>
                    </div>

                    {{-- Bank --}}
                    <div class="card-body">
                        <div class="row align-items-center mb-3">
                            <label class="col-md-3 col-form-label mb-0">{{ translate('Bank') }}</label>
                            <div class="col-md-9">
                                <label class="aiz-switch aiz-switch-success mb-0">
                                    <input type="checkbox" name="bank_payout_status" value="1"
                                        @if ((int) ($user->bank_payout_status ?? 0) === 1) checked @endif>
                                    <span class="slider round"></span>
                                </label>
                            </div>
                        </div>

                        <div class="row mb-3">
                            <label class="col-md-3 col-form-label">{{ translate('Bank Name') }}</label>
                            <div class="col-md-9">
                                <input type="text" name="bank_name" class="form-control"
                                    value="{{ old('bank_name', $user->bank_name ?? '') }}"
                                    placeholder="{{ translate('Bank Name') }}">
                            </div>
                        </div>

                        <div class="row mb-3">
                            <label class="col-md-3 col-form-label">{{ translate('Account Name') }}</label>
                            <div class="col-md-9">
                                <input type="text" name="bank_acc_name" class="form-control"
                                    value="{{ old('bank_acc_name', $user->bank_acc_name ?? '') }}"
                                    placeholder="{{ translate('Account Holder Name') }}">
                            </div>
                        </div>

                        <div class="row">
                            <label class="col-md-3 col-form-label">{{ translate('Account Number') }}</label>
                            <div class="col-md-9">
                                <input type="text" name="bank_acc_no" class="form-control"
                                    value="{{ old('bank_acc_no', $user->bank_acc_no ?? '') }}"
                                    placeholder="{{ translate('XXXXXXXXXXXX') }}">
                                <small class="form-text text-danger mt-1">
                                    {{ translate('Payout fee:') }}
                                    {{ format_price((float) (get_setting('payout_fee_amount', 25) ?? 25), true) }}
                                </small>
                            </div>
                        </div>
                    </div>

                    <div class="card-body border-top">
                        <div class="text-right">
                            <button type="submit" class="btn btn-sm btn-primary">
                                {{ translate('Save Settings') }}
                            </button>
                        </div>
                    </div>
                </div>

            </form>
        </div>
    </div>
@endsection
