@extends('backend.layouts.app')

@section('content')
    <div class="card">
        <form id="sort_products" action="{{ route('merchant.products.index') }}" method="GET">
            <div class="card-header row gutters-5">
                <div class="col text-center text-md-left">
                    <h5 class="mb-md-0 h6">{{ translate('All Products') }}</h5>
                </div>

                <div class="col-md-2">
                    <select class="form-control form-control-sm aiz-selectpicker mb-2 mb-md-0" name="type" id="type"
                        onchange="document.getElementById('sort_products').submit()">
                        <option value="">{{ translate('Sort By') }}</option>
                        <option value="num_of_sale,desc"
                            @isset($col_name, $query) @if ($col_name == 'num_of_sale' && $query == 'desc') selected @endif @endisset>
                            {{ translate('Num of Sale (High > Low)') }}
                        </option>
                        <option value="num_of_sale,asc"
                            @isset($col_name, $query) @if ($col_name == 'num_of_sale' && $query == 'asc') selected @endif @endisset>
                            {{ translate('Num of Sale (Low > High)') }}
                        </option>
                        <option value="unit_price,desc"
                            @isset($col_name, $query) @if ($col_name == 'unit_price' && $query == 'desc') selected @endif @endisset>
                            {{ translate('Base Price (High > Low)') }}
                        </option>
                        <option value="unit_price,asc"
                            @isset($col_name, $query) @if ($col_name == 'unit_price' && $query == 'asc') selected @endif @endisset>
                            {{ translate('Base Price (Low > High)') }}
                        </option>
                    </select>
                </div>

                <div class="col-md-2">
                    <div class="input-group">
                        <input type="text" class="form-control form-control-sm" id="search" name="search"
                            @isset($sort_search) value="{{ $sort_search }}" @endisset
                            placeholder="{{ translate('Type & Enter') }}">
                    </div>
                </div>

                <div class="ml-2">
                    @can('merchant.view_products')
                        <a href="{{ route('merchant.products.create') }}" class="btn btn-primary">
                            <span>{{ translate('Add New Product') }}</span>
                        </a>
                    @endcan
                </div>
            </div>
        </form>

        <div class="card-body">
            <table class="table aiz-table mb-0">
                <thead>
                    <tr>
                        <th class="w-40px">#</th>
                        <th class="col-xl-2">{{ translate('Name') }}</th>
                        <th data-breakpoints="md">{{ translate('Info') }}</th>
                        <th data-breakpoints="md">{{ translate('Description') }}</th>
                        <th data-breakpoints="md" class="text-right">{{ translate('Options') }}</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach ($products as $key => $product)
                        <tr>
                            <td>{{ $key + 1 + ($products->currentPage() - 1) * $products->perPage() }}</td>

                            <td>
                                <div class="d-flex align-items-center">
                                    <img src="{{ uploaded_asset($product->thumbnail_img) }}" alt="Image"
                                        class="size-60px size-xxl-80px mr-2"
                                        onerror="this.onerror=null;this.src='{{ static_asset('/assets/img/placeholder.jpg') }}';" />
                                    <span class="flex-grow-1 minw-0">
                                        <div class="text-truncate-2 fs-12">
                                            {{ $product->getTranslation('name') }}
                                        </div>
                                    </span>
                                </div>
                            </td>

                            <td>
                                <div>
                                    <div>
                                        <span>{{ translate('Total Sold') }}</span>:
                                        <span class="fw-600">{{ $product->num_of_sale }}</span>
                                    </div>
                                    <div>
                                        <span>{{ translate('Price') }}</span>:
                                        @if (($product->highest_price ?? 0) != ($product->lowest_price ?? 0))
                                            <span class="fw-600">
                                                {{ format_price($product->lowest_price) }} -
                                                {{ format_price($product->highest_price) }}
                                            </span>
                                        @else
                                            <span class="fw-600">
                                                {{ format_price($product->lowest_price ?? $product->price) }}
                                            </span>
                                        @endif
                                    </div>
                                </div>
                            </td>

                            <td>
                                <div class="text-truncate-3" style="max-width: 420px">{!! $product->description !!}</div>
                            </td>

                            <td class="text-right">
                                @can('merchant.view_products')
                                    <a class="btn btn-soft-info btn-icon btn-circle btn-sm"
                                        href="{{ route('merchant.products.edit', $product->id) }}"
                                        title="{{ translate('Edit') }}">
                                        <i class="las la-edit"></i>
                                    </a>
                                @endcan

                                @can('merchant.view_products')
                                    <a href="javascript:void(0)"
                                        class="btn btn-soft-danger btn-icon btn-circle btn-sm confirm-delete"
                                        data-href="{{ route('merchant.products.destroy', $product->id) }}"
                                        title="{{ translate('Delete') }}">
                                        <i class="las la-trash"></i>
                                    </a>
                                @endcan
                            </td>
                        </tr>
                    @endforeach
                </tbody>
            </table>

            <div class="aiz-pagination">
                {{ $products->appends(request()->input())->links() }}
            </div>
        </div>
    </div>

    @php
        CoreComponentRepository::instantiateShopRepository();
    @endphp
@endsection

@section('modal')
    {{-- This partial must contain @csrf and @method('DELETE') in the form --}}
    @include('backend.merchants.products.inc.delete_modal')
@endsection

@section('script')
    <script>
        // Wire up the shared delete modal to RESTful DELETE route
        $(document).on('click', '.confirm-delete', function(e) {
            e.preventDefault();
            var href = $(this).data('href');
            var $modal = $('#delete-modal');
            $modal.find('form').attr('action', href);
            $modal.modal('show');
        });
    </script>
@endsection
