@extends('backend.layouts.app')

@section('content')
    <div class="aiz-titlebar text-left mt-2 mb-3">
        <h5 class="mb-0 h6">{{ translate('Add New Product') }}</h5>
    </div>
    <form class="form form-horizontal mar-top" action="{{ route('product.store') }}" method="POST"
        enctype="multipart/form-data" id="product_form">
        @csrf
        <div class="row gutters-5">
            <div class="col-lg">

                {{-- Product Information --}}
                <div class="card">
                    <div class="card-header">
                        <h5 class="mb-0 h6">{{ translate('Product Information') }}</h5>
                    </div>
                    <div class="card-body">
                        <div class="form-group row">
                            <label class="col-md-3 col-from-label">
                                {{ translate('Product Name') }} <span class="text-danger">*</span>
                            </label>
                            <div class="col-md-8">
                                <input type="text" class="form-control" name="name"
                                    placeholder="{{ translate('Product Name') }}" required>
                            </div>
                        </div>
                        <div class="form-group row">
                            <label class="col-md-3 col-from-label">{{ translate('Unit') }}</label>
                            <div class="col-md-8">
                                <input type="text" class="form-control" name="unit"
                                    placeholder="{{ translate('Unit (e.g. 500 Gram, 2 Litre, 5 Pc etc)') }}">
                            </div>
                        </div>
                    </div>
                </div>

                {{-- Product Images --}}
                <div class="card">
                    <div class="card-header">
                        <h5 class="mb-0 h6">{{ translate('Product Images') }}</h5>
                    </div>
                    <div class="card-body">
                        <div class="form-group row">
                            <label class="col-md-3 col-form-label">
                                {{ translate('Thumbnail Image') }} <small>(300x300)</small>
                            </label>
                            <div class="col-md-8">
                                <div class="input-group" data-toggle="aizuploader" data-type="image" data-mu>
                                    <div class="input-group-prepend">
                                        <div class="input-group-text bg-soft-secondary font-weight-medium">
                                            {{ translate('Browse') }}
                                        </div>
                                    </div>
                                    <div class="form-control file-amount">{{ translate('Choose File') }}</div>
                                    <input type="hidden" name="thumbnail_img" class="selected-files">
                                </div>
                                <div class="file-preview box sm"></div>
                                <small class="text-muted">
                                    {{ translate('This image is visible in all product box. Use 300x300 sizes image. Keep some blank space around the main object of your image as we had to crop some edge in different devices to make it responsive.') }}
                                </small>
                            </div>
                        </div>
                        {{-- Gallery images kept disabled --}}
                        {{-- ... --}}
                    </div>
                </div>

                {{-- Price and Stock --}}
                <div class="card">
                    <div class="card-body">
                        <div class="no_product_variant">
                            <div class="form-group row">
                                <label class="col-md-3 col-from-label">
                                    {{ translate('Regular price') }} <span class="text-danger">*</span>
                                </label>
                                <div class="col-md-8">
                                    <input type="number" step="0.01" min="0" value="1"
                                        placeholder="{{ translate('Price') }}" name="price" class="form-control"
                                        required>
                                </div>
                            </div>
                            {{-- SKU removed --}}
                            <div class="form-group row">
                                <label class="col-md-3 col-from-label">
                                    {{ translate('Stock') }} <span class="text-danger">*</span>
                                </label>
                                <div class="col-md-8">
                                    <select class="form-control aiz-selectpicker" name="stock">
                                        <option value="1">{{ translate('In stock') }}</option>
                                        <option value="0">{{ translate('Out of stock') }}</option>
                                    </select>
                                </div>
                            </div>
                        </div>

                        <div class="has_product_variant" style="display: none">
                            <div class="alert alert-info">
                                {{ translate('Select an option for this product and then select choices of each option. Max 3 options') }}
                            </div>

                            <div class="customer_choice_options">
                                <div class="form-group row gutters-10">
                                    <div class="col attr-values">
                                        <div class="form-control">
                                            <span>{{ translate('Select an option') }}</span>
                                        </div>
                                    </div>
                                    <div class="col-auto">
                                        <button type="button" class="btn btn-icon btn-soft-secondary"
                                            onclick="add_new_option()">
                                            <i class="la-plus las opacity-70"></i>
                                        </button>
                                    </div>
                                </div>
                            </div>

                            <div class="sku_combination" id="sku_combination"></div>
                        </div>
                    </div>
                </div>

                @if (get_setting('club_point'))
                    <div class="card">
                        <div class="card-header">
                            <h5 class="mb-0 h6">{{ translate('Club Point') }}</h5>
                        </div>
                        <div class="card-body">
                            <div class="form-group row">
                                <label class="col-sm-3 control-label">
                                    {{ translate('Set Point') }}
                                </label>
                                <div class="col-sm-9">
                                    <input type="number" lang="en" min="0" value="0" step="1"
                                        placeholder="1" name="earn_point" class="form-control">
                                </div>
                            </div>
                        </div>
                    </div>
                @endif

                {{-- Product Description --}}
                <div class="card">
                    <div class="card-header">
                        <h5 class="mb-0 h6">{{ translate('Product Description') }}</h5>
                    </div>
                    <div class="card-body">
                        <div class="form-group row">
                            <label class="col-md-3 col-from-label">{{ translate('Description') }}</label>
                            <div class="col-md-8">
                                <textarea class="aiz-text-editor" name="description"></textarea>
                            </div>
                        </div>
                    </div>
                    {{-- Short Description removed --}}
                </div>
            </div>

            <div class="col col-lg-auto w-lg-300px w-xxl-400px">
                {{-- Product Status --}}
                <div class="card">
                    <div class="card-header">
                        <h5 class="mb-0 h6">{{ translate('Product Status') }}</h5>
                    </div>
                    <div class="card-body">
                        <select class="form-control aiz-selectpicker" name="status">
                            <option value="0">{{ translate('Draft') }}</option>
                            <option value="1" selected>{{ translate('Published') }}</option>
                        </select>
                    </div>
                </div>

                {{-- Product Category (treeview block left commented as in your file) --}}
                {{-- ... --}}

                {{-- Product Tags removed --}}
            </div>
        </div>

        <div class="mar-all text-right mb-3">
            <button type="submit" class="btn btn-primary" id="upload-product">
                {{ translate('Upload Product') }}
            </button>
        </div>
    </form>
@endsection

@section('script')
    <!-- Treeview js -->
    <script src="{{ static_asset('assets/js/hummingbird-treeview.js') }}"></script>
    <script type="text/javascript">
        $('#product_form').bind('submit', function(e) {
            $("#upload-product").prop('disabled', true);
            var valid = true;

            if (!valid) {
                e.preventDefault();
                $("#upload-product").prop('disabled', false);
            }
        });

        function is_variant_product(el) {
            $(".has_product_variant").hide();
            $(".no_product_variant").hide();
            if ($(el).is(':checked')) {
                $(".has_product_variant").show();
            } else {
                $(".no_product_variant").show();
            }
        }

        function add_new_option() {
            $.ajax({
                type: "POST",
                data: $('#product_form').serialize(),
                url: '{{ route('product.new_option') }}',
                success: function(data) {
                    if (data.count == -2) {
                        AIZ.plugins.notify('warning', '{{ translate('Maximum option limit reached.') }}');
                    } else if (data.count == -1) {
                        AIZ.plugins.notify('warning', '{{ translate('Please select an option.') }}');
                    } else if (data.count > 0) {
                        $('.customer_choice_options')
                            .find('.attr-names')
                            .find('.aiz-selectpicker')
                            .siblings('.dropdown-toggle')
                            .addClass("disabled");
                        $('.customer_choice_options').append(data.view);
                        AIZ.plugins.bootstrapSelect();
                    } else {
                        AIZ.plugins.notify('info', '{{ translate('No more option found.') }}');
                    }
                }
            });
        }

        function update_sku() {
            $.ajax({
                type: "POST",
                url: '{{ route('product.sku_combination') }}',
                data: $('#product_form').serialize(),
                success: function(data) {
                    $('#sku_combination').html(data);
                    setTimeout(() => {
                        AIZ.uploader.previewGenerate();
                        AIZ.plugins.bootstrapSelect('refresh');
                    }, 500);
                }
            });
        }
    </script>
    <script>
        $(document).ready(function() {
            $("#treeview").hummingbird();

            $('#treeview input[type=checkbox]').change(function() {
                var selected = document.querySelector('#treeview input[type="radio"]:checked');
                if (selected == null) {
                    var value = $(this).val();
                    $('#treeview input:radio[value=' + value + ']').prop('checked', true);
                }
            });
        });
    </script>
@endsection
