@extends('backend.layouts.app')

@section('content')
    <div class="card">
        <div class="col-lg-12">
            <div class="card-header row gutters-5">
                <div class="col text-center text-md-left">
                    <h5 class="mb-0 h6">{{ translate('Staffs') }}</h5>
                </div>
                @can('add_staffs')
                    <div class="col-md-6 text-md-right">
                        <a href="{{ route('staffs.create') }}" class="btn btn-circle btn-primary">
                            <span>{{ translate('Add New Staffs') }}</span>
                        </a>
                    </div>
                @endcan
            </div>
            <div class="card-body">
                <table class="table aiz-table mb-0">
                    <thead>
                        <tr>
                            <th width="10%">#</th>
                            <th>{{ translate('Name') }}</th>
                            <th data-breakpoints="md">{{ translate('Email') }}</th>
                            <th data-breakpoints="md">{{ translate('Phone') }}</th>
                            <th>{{ translate('Role') }}</th>
                            <th class="text-right">{{ translate('Options') }}</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach ($users as $key => $user)
                            <tr>
                                <td>{{ $key + 1 + ($users->currentPage() - 1) * $users->perPage() }}</td>
                                <td>{{ $user->name }}</td>
                                <td>{{ $user->email }}</td>
                                <td>{{ $user->phone }}</td>
                                <td>
                                    @if ($user->role != null)
                                        {{ $user->role->name }}
                                    @endif
                                </td>
                                <td class="text-right">
                                    @can('edit_staffs')
                                        <a class="btn btn-soft-primary btn-icon btn-circle btn-sm"
                                            href="{{ route('staffs.edit', encrypt($user->id)) }}"
                                            title="{{ translate('Edit') }}">
                                            <i class="las la-edit"></i>
                                        </a>
                                    @endcan
                                    @can('delete_staffs')
                                        <a href="#" class="btn btn-soft-danger btn-icon btn-circle btn-sm confirm-delete"
                                            data-href="{{ route('staffs.destroy', $user->id) }}"
                                            title="{{ translate('Delete') }}">
                                            <i class="las la-trash"></i>
                                        </a>
                                    @endcan
                                </td>
                            </tr>
                        @endforeach
                    </tbody>
                </table>
                <div class="aiz-pagination">
                    {{ $users->appends(request()->input())->links() }}
                </div>
            </div>
        </div>
    </div>
@endsection

@section('modal')
    @include('backend.inc.delete_modal')
@endsection
