<form id="package_payment_form" action="{{ route('seller.new_seller_payment_upload_proof') }}" method="POST"
    enctype="multipart/form-data">
    @csrf

    <div class="modal-header">
        <h5 class="modal-title h6">{{ translate('Upload Payment Proof') }}</h5>
        <button type="button" class="close" data-dismiss="modal"></button>
    </div>

    @php
        $pendingPaymentId = null;

        if (isset($pendingPayment) && $pendingPayment) {
            $pendingPaymentId = $pendingPayment->id;
        } else {
            $u = Auth::user();
            if ($u && method_exists($u, 'sellerPackagePayment')) {
                $pp = $u
                    ->sellerPackagePayment()
                    ->whereIn('approval', [0, 3]) // 0=pending, 3=proof uploaded
                    ->latest('id')
                    ->first();
                $pendingPaymentId = optional($pp)->id;
            }
        }
    @endphp

    @if ($pendingPaymentId)
        <input type="hidden" name="payment_id" value="{{ $pendingPaymentId }}">
    @endif

    <div class="modal-body" style="padding: 20px 25px;">
        <div class="row gutters-5 align-items-center">
            <div class="col">
                <div class="card overflow-hidden">
                    <div class="card-body align-items-center justify-content-center">

                        <div class="form-group row">
                            <label class="w-100">
                                {{ translate('Select Payment Option') }}: <span class="text-danger">*</span>
                            </label>
                            <div class="row gutters-5 card-body d-flex align-items-center justify-content-center">
                                @foreach ($manual_payment_methods as $method)
                                    @php $uid = 'pm_' . ($method->id ?? \Illuminate\Support\Str::random(8)); @endphp
                                    <div class="col-6 col-md-4">
                                        <label class="aiz-megabox d-block mb-3" for="{{ $uid }}">
                                            <input id="{{ $uid }}" type="radio" name="payment_method"
                                                value="{{ $method->heading }}" class="d-none" required>
                                            <span class="d-block p-3 aiz-megabox-elem">
                                                <img src="{{ uploaded_asset($method->logo) }}" class="img-fluid mb-2"
                                                    alt="{{ $method->heading }}">
                                                <span class="d-block text-center">
                                                    <span class="d-block fw-600 fs-15">{{ $method->heading }}</span>
                                                </span>
                                            </span>
                                        </label>
                                    </div>
                                @endforeach
                            </div>
                            @error('payment_method')
                                <div class="col-12 text-danger small mt-1">{{ $message }}</div>
                            @enderror
                        </div>

                        <div class="form-group row">
                            <label class="col-md-3 col-form-label">
                                {{ translate('Photo') }} <span class="text-danger">*</span>
                            </label>
                            <div class="col-md-9">
                                <div class="input-group" data-toggle="aizuploader" data-type="image">
                                    <div class="input-group-prepend">
                                        <div class="input-group-text bg-soft-secondary font-weight-medium">
                                            {{ translate('Browse') }}
                                        </div>
                                    </div>
                                    <div class="form-control file-amount">
                                        {{ translate('Choose image') }}
                                    </div>
                                    <input type="hidden" name="photo_proof" class="selected-files" required>
                                </div>
                                <div class="file-preview box sm"></div>
                                @error('photo_proof')
                                    <div class="text-danger small mt-1">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>

                        @error('payment_id')
                            <div class="alert alert-danger w-100 mt-2 mb-0">{{ $message }}</div>
                        @enderror

                        @if (!$pendingPaymentId)
                            <div class="alert alert-warning w-100 mt-2 mb-0">
                                {{ translate('No pending membership payment found to attach a proof to.') }}
                            </div>
                        @endif

                    </div>
                </div>
            </div>
        </div>

        <div class="text-right">
            <button type="submit" class="btn btn-primary" {{ $pendingPaymentId ? '' : 'disabled' }}>
                {{ translate('Upload') }}
            </button>
        </div>
    </div>
</form>
