@extends('backend.layouts.page')

@section('content')
    @if (Auth::check())
        <div class="col-lg-12 mx-auto">
            <div class="row">
                <div class="col-lg-10 mx-auto">

                    {{-- Already approved? --}}
                    @if ($payment && (int) $payment->approval === 1)
                        <div class="card-header justify-content-center bg-transparent border-0">
                            <h1 class="mb-0 h6 text-center">{{ translate('Your account has already been approved!') }}</h1>
                        </div>
                        <div class="d-flex justify-content-center">
                            <a href="{{ route('seller.dashboard') }}" title="Go to Dashboard">
                                <span class="btn btn-soft-primary custom-btn-home">Go to Dashboard</span>
                            </a>
                        </div>
                    @else
                        <div class="card mt-4">
                            @if ($payment && (int) $payment->approval === 3)
                                <div class="card-header justify-content-center">
                                    <h1 class="mb-0 h6">{{ translate('Thank you for submitting your payment proof!') }}</h1>
                                </div>
                            @else
                                <div class="card-header">
                                    <h1 class="mb-0 h6">{{ translate('Welcome to ') }} {{ get_setting('site_name') }}!</h1>
                                </div>
                            @endif

                            @if ($payment && (int) $payment->approval === 3)
                                <div class="card-body">
                                    <p class="text-center">
                                        We have received your submission, and our team will now review and validate it.<br>
                                        You will receive an email notification once your submission has been validated.
                                    </p>
                                    <div class="d-flex justify-content-center">
                                        <a href="{{ route('login') }}" class="btn btn-primary">
                                            {{ translate('Go to Login Page') }}
                                        </a>
                                    </div>
                                </div>
                            @else
                                <div class="card-body">
                                    <div class="row no-gutters align-center">
                                        <div class="col-lg-12 order-lg-1 col-12 order-2">
                                            <p>Dear, <strong>{{ $user->name }}</strong></p>

                                            <p>Congratulations on joining our <strong>Membership Program!</strong></p>

                                            <p><strong>Here's what you need to do:</strong></p>

                                            <ol>
                                                <li>
                                                    <strong>Your Chosen Package: {{ $packageName ?? 'N/A' }}</strong><br>
                                                    Settle your package payment to unlock the full earning potential.
                                                    <div class="form-group row">
                                                        <div
                                                            style="display:flex;flex-direction:row;justify-content:center;">
                                                            @foreach ($manual_payment_methods as $method)
                                                                <div class="col-6 col-md-4">
                                                                    <label class="aiz-megabox d-block"
                                                                        @if ($payment) onclick="select_payment_upload_modal({{ $payment->id }})" @endif>
                                                                        <span class="d-block p-3">
                                                                            <img src="{{ uploaded_asset($method->logo) }}"
                                                                                class="img-fluid mb-2">
                                                                            <span class="d-block text-center">
                                                                                <span
                                                                                    class="d-block fw-600 fs-15">{{ $method->heading }}</span>
                                                                            </span>
                                                                        </span>
                                                                    </label>
                                                                    <span class="d-block text-center">
                                                                        <span
                                                                            class="d-block fw-400 fs-15">{!! $method->description !!}</span>
                                                                    </span>
                                                                </div>
                                                            @endforeach
                                                        </div>
                                                    </div>
                                                </li>

                                                <li><strong>Submit Payment Details:</strong> Use the upload feature below.
                                                </li>
                                                <li><strong>Confirmation and Access:</strong> We’ll email you after
                                                    validation.</li>
                                            </ol>

                                            @if ($referrerName)
                                                <p>Referred by: <strong>{{ $referrerName }}</strong></p>
                                            @endif
                                        </div>
                                    </div>
                                </div>

                                <div class="card-body">
                                    <div class="text-center">
                                        @if ($payment)
                                            <button type="button" class="btn btn-primary"
                                                onclick="select_payment_upload_modal({{ $payment->id }})">
                                                {{ translate('Upload Payment Proof') }}
                                            </button>
                                        @endif
                                    </div>
                                </div>
                            @endif
                        </div>
                    @endif


                </div>
            </div>
        </div>
    @else
        <div class="col-lg-6 mx-auto">
            <div class="row">
                <div class="col-lg-10 mx-auto">
                    <div class="card">
                        <div class="col-lg-6 mx-auto">
                            <img src="{{ static_asset('assets/img/404.svg') }}" class="mw-100 mx-auto mb-5" height="300">
                            <h1 class="fw-700">{{ translate('Page Not Found!') }}</h1>
                            <p class="fs-16 opacity-60">
                                {{ translate('The page you are looking for has not been found on our server.') }}</p>
                        </div>
                        <div class="card-header justify-content-center">
                            <a href="{{ route('login') }}" class="btn btn-primary">{{ translate('Go to Login Page') }}</a>
                        </div>
                    </div>

                </div>
            </div>
        </div>
    @endif
@endsection

@section('modal')
    <div class="modal fade" id="payment_upload_modal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel"
        aria-hidden="true">
        <div class="modal-dialog modal-md modal-dialog-centered" role="document">
            <div class="modal-content" id="pages-payment-upload-modal-content">

            </div>
        </div>
    </div>
@endsection

@section('script')
    <script>
        (function($) {
            window.select_payment_upload_modal = function(id) {
                $.post('{{ route('seller.payment_upload_modal') }}', {
                    _token: '{{ csrf_token() }}',
                    id: id
                }, function(html) {
                    $('#pages-payment-upload-modal-content').html(html);
                    $('#payment_upload_modal').modal('show', {
                        backdrop: 'static'
                    });

                    if (window.AIZ && AIZ.plugins && AIZ.plugins.aizuploader) {
                        AIZ.plugins.aizuploader();
                    }
                });
            };
        })(jQuery);
    </script>
@endsection
