<!doctype html>
<html lang="<?php echo e(str_replace('_', '-', app()->getLocale())); ?>">

<head>
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
    <meta name="app-url" content="<?php echo e(getBaseURL()); ?>">
    <meta name="file-base-url" content="<?php echo e(getFileBaseURL()); ?>">
    <meta http-equiv="refresh" content="<?php echo e(config('session.lifetime') * 60); ?>">

    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">

    <link rel="icon" href="<?php echo e(static_asset('assets/img/favicon.ico')); ?>" type="image/x-icon">
    <title><?php echo e(config('app.name', 'The Shop')); ?></title>

    <!-- Fonts & CSS -->
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Roboto:wght@300;400;500;700;900&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="<?php echo e(static_asset('assets/css/vendors.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(static_asset('assets/css/aiz-core.css')); ?>">

    <script>
        var AIZ = AIZ || {};
        AIZ.local = {
            nothing_selected: '<?php echo e(translate('Nothing selected')); ?>',
            nothing_found: '<?php echo e(translate('Nothing found')); ?>',
            choose_file: '<?php echo e(translate('Choose file')); ?>',
            file_selected: '<?php echo e(translate('File selected')); ?>',
            files_selected: '<?php echo e(translate('Files selected')); ?>',
            add_more_files: '<?php echo e(translate('Add more files')); ?>',
            adding_more_files: '<?php echo e(translate('Adding more files')); ?>',
            drop_files_here_paste_or: '<?php echo e(translate('Drop files here, paste or')); ?>',
            browse: '<?php echo e(translate('Browse')); ?>',
            upload_complete: '<?php echo e(translate('Upload complete')); ?>',
            upload_paused: '<?php echo e(translate('Upload paused')); ?>',
            resume_upload: '<?php echo e(translate('Resume upload')); ?>',
            pause_upload: '<?php echo e(translate('Pause upload')); ?>',
            retry_upload: '<?php echo e(translate('Retry upload')); ?>',
            cancel_upload: '<?php echo e(translate('Cancel upload')); ?>',
            uploading: '<?php echo e(translate('Uploading')); ?>',
            processing: '<?php echo e(translate('Processing')); ?>',
            complete: '<?php echo e(translate('Complete')); ?>',
            file: '<?php echo e(translate('File')); ?>',
            files: '<?php echo e(translate('Files')); ?>',
        }
    </script>

    <style>
        /* Page uses a flex column so footer can stick to bottom naturally */
        .aiz-main-content {
            min-height: 100vh;
            display: flex;
            flex-direction: column;
        }

        /* Center area: constrain width for large screens, full width on mobile */
        .aiz-centered-container {
            width: 100%;
            max-width: 720px;
            /* tweak as you like (600–840px is nice) */
        }

        /* Ensure no weird horizontal scroll on tiny screens */
        body {
            overflow-x: hidden;
        }
    </style>
</head>

<body class="min-vh-100 d-flex flex-column">

    <div class="aiz-main-content">
        <!-- MAIN (centered both axes) -->
        <main class="flex-grow-1 d-flex align-items-center justify-content-center py-5 px-3">
            <div class="aiz-centered-container w-100">
                <?php echo $__env->yieldContent('content'); ?>
            </div>
        </main>

        <!-- FOOTER (sticky, non-fixed, won’t overlap content) -->
        <footer class="bg-white text-center py-3 px-3 mt-auto">
            <p class="mb-0">&copy; <?php echo e(get_setting('site_name')); ?> <?php echo e(date('Y')); ?></p>
        </footer>
    </div><!-- .aiz-main-content -->

    <?php echo $__env->yieldContent('modal'); ?>

    <script src="<?php echo e(static_asset('assets/js/vendors.js')); ?>"></script>
    <script src="<?php echo e(static_asset('assets/js/aiz-core.js')); ?>"></script>

    <?php echo $__env->yieldContent('script'); ?>

    <script type="text/javascript">
        <?php $__currentLoopData = session('flash_notification', collect())->toArray(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $message): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            AIZ.plugins.notify('<?php echo e($message['level']); ?>', '<?php echo e($message['message']); ?>');
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    </script>
</body>

</html>
<?php /**PATH /home/itreszse/app.luvorebeautyandco.com/resources/views/backend/layouts/page.blade.php ENDPATH**/ ?>