

<?php $__env->startSection('content'); ?>
    <div class="h-100 bg-cover bg-center py-5 d-flex align-items-center"
        style="background-image: url(<?php echo e(uploaded_asset(get_setting('admin_login_background'))); ?>)">
        <div class="container">
            <div class="row">
                <div class="col-lg-6 col-xl-4 mx-auto">
                    <div class="card text-left bg-transparent">
                        <div class="absolute-full bg-white opacity-70"></div>
                        <div class="card-body position-relative z-1">
                            <div class="mb-4 text-center">
                                <img src="<?php echo e(uploaded_asset(get_setting('system_logo_black'))); ?>" class="mw-100 mb-4"
                                    height="100" alt="<?php echo e(get_setting('site_name')); ?>">
                                <p class="fs-15 opacity-80 mt-3"><?php echo e(translate('Login to your account.')); ?></p>
                            </div>
                            <form class="pad-hor" method="POST" role="form" action="<?php echo e(route('login')); ?>">
                                <?php echo csrf_field(); ?>
                                <div class="form-group">
                                    <label class="mb-1"><?php echo e(translate('Email')); ?></label>
                                    <input id="email" type="email"
                                        class="form-control<?php echo e($errors->has('email') ? ' is-invalid' : ''); ?>" name="email"
                                        value="<?php echo e(old('email')); ?>" required autofocus
                                        placeholder="<?php echo e(translate('Email')); ?>">
                                    <?php if($errors->has('email')): ?>
                                        <span class="invalid-feedback" role="alert">
                                            <strong><?php echo e($errors->first('email')); ?></strong>
                                        </span>
                                    <?php endif; ?>
                                </div>
                                <div class="form-group">
                                    <label class="mb-1"><?php echo e(translate('Password')); ?></label>
                                    <input id="password" type="password"
                                        class="form-control<?php echo e($errors->has('password') ? ' is-invalid' : ''); ?>"
                                        name="password" required placeholder="<?php echo e(translate('Password')); ?>">
                                    <?php if($errors->has('password')): ?>
                                        <span class="invalid-feedback" role="alert">
                                            <strong><?php echo e($errors->first('password')); ?></strong>
                                        </span>
                                    <?php endif; ?>
                                </div>
                                <div class="row mb-2">
                                    <div class="col-sm-6">
                                        <div class="text-left">
                                            <label class="aiz-checkbox">
                                                <input type="checkbox" name="remember" id="remember"
                                                    <?php echo e(old('remember') ? 'checked' : ''); ?>>
                                                <span><?php echo e('Remember Me'); ?></span>
                                                <span class="aiz-square-check bg-white"></span>
                                            </label>
                                        </div>
                                    </div>
                                    <?php if(env('MAIL_USERNAME') != null && env('MAIL_PASSWORD') != null): ?>
                                        <div class="col-sm-6">
                                            <div class="text-right">
                                                <a href="<?php echo e(route('password.request')); ?>"
                                                    class="text-reset fs-14"><?php echo e('Forgot Password'); ?>?</a>
                                            </div>
                                        </div>
                                    <?php endif; ?>
                                </div>
                                <button type="submit" class="btn btn-primary btn-lg btn-block">
                                    <?php echo e('Login'); ?>

                                </button>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('backend.layouts.blank', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/itreszse/app.luvorebeautyandco.com/resources/views/auth/login.blade.php ENDPATH**/ ?>