<?php

namespace Tests\Feature;

use Tests\TestCase;
use Illuminate\Foundation\Testing\RefreshDatabase;
use App\Models\Product;
use App\Models\Shop;
use App\Models\State;
use App\Models\User;

class OrderControllerTest extends TestCase
{
  // use RefreshDatabase;

  public function test_order_store_with_real_data()
  {
    // Setup test data using factories
    $state = State::factory()->create(['state_code' => 'ISA', 'name' => 'Isabela']);
    $shop = Shop::factory()->create();
    $product = Product::factory()->create(['shop_id' => $shop->id, 'lowest_price' => 270]);

    $payload = [
      'billing' => [
        'first_name' => 'John',
        'last_name' => 'Doe',
        'email' => 'john@example.com',
        'phone' => '09123456789',
        'address_1' => '123 Main St',
        'address_2' => 'Brgy. Sample',
        'city' => 'Santiago',
        'state' => 'ISA',
      ],
      'meta_data' => [
        ['key' => '_billing_seller_id', 'value' => $shop->id],
      ],
      'line_items' => [
        ['product_id' => $product->id, 'quantity' => 2]
      ],
      'shipping_lines' => [
        ['method_title' => 'express']
      ],
      'shipping_total' => 20.00,
      'payment_method_title' => 'Cash on Delivery',
      'email' => 'john@example.com',
    ];


    $user = User::factory()->create();
    $this->actingAs($user, 'api'); // 'api' is the guard name

    $response = $this->postJson('/api/v1/checkout/order/store', $payload);

    $response->assertStatus(200)
      ->assertJson(['success' => true]);

    $this->assertDatabaseHas('orders', [
      'email' => 'john@example.com',
      'shipping_cost' => 20,
      'grand_total' => 560,
    ]);
  }
}
