<?php

namespace App\Addons\Multivendor\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\CommissionHistory;
use Illuminate\Http\Request;

class CommissionController extends Controller
{
    public function __construct()
    {
        $this->middleware(['permission:show_commission_log'])->only('commission_history');
    }

    public function commission_history(Request $request)
    {
        $user_id    = $request->user_id ?: null;
        $date_range = $request->date_range ?: null;

        $query = CommissionHistory::with(['order', 'user']);

        if ($date_range) {
            [$start, $end] = array_map('trim', array_pad(explode(' / ', $date_range), 2, null));
            if ($start && $end) {
                $query->whereDate('created_at', '>=', $start)
                      ->whereDate('created_at', '<=', $end);
            }
        }

        if ($user_id) {
            $query->where('user_id', $user_id);
        }

        $commission_history = \App\Models\CommissionHistory::with(['order','user'])
    ->when($user_id, fn($q) => $q->where('user_id', $user_id))
    ->when($date_range, function ($q) use ($date_range) {
        [$start, $end] = array_map('trim', array_pad(explode(' / ', $date_range), 2, null));
        if ($start && $end) {
            $q->whereDate('created_at', '>=', $start)
              ->whereDate('created_at', '<=', $end);
        }
    })
    ->latest()
    ->paginate(10)
    ->appends($request->query());

        return view('addon:multivendor::admin.commission_history', compact('commission_history', 'user_id', 'date_range'));
    }
}
