<?php

namespace App\Addons\Multivendor\Http\Controllers\Seller;

use App\Http\Controllers\Controller;
use App\Models\CommissionHistory;
use Illuminate\Http\Request;

class CommissionController extends Controller
{
    public function commission_history(Request $request)
    {
        $referrerUserId = auth()->id();
        $date_range     = $request->date_range;

        $query = CommissionHistory::with('order')->where('user_id', $referrerUserId);

        if ($date_range) {
            [$start, $end] = array_map('trim', array_pad(explode(' / ', $date_range), 2, null));
            if ($start && $end) {
                $query->whereDate('created_at', '>=', $start)
                      ->whereDate('created_at', '<=', $end);
            }
        }

        $commission_history = \App\Models\CommissionHistory::with('order')
    ->where('user_id', auth()->id())
    ->when($date_range, function ($q) use ($date_range) {
        [$start, $end] = array_map('trim', array_pad(explode(' / ', $date_range), 2, null));
        if ($start && $end) {
            $q->whereDate('created_at', '>=', $start)
              ->whereDate('created_at', '<=', $end);
        }
    })
    ->latest()
    ->paginate(10)
    ->appends($request->query());

        return view(
            'addon:multivendor::seller.earnings.commission_history',
            compact('commission_history', 'referrerUserId', 'date_range')
        );
    }
}
