<form class="form-horizontal" action="{{ route('admin.package_payment_approval') }}" method="POST"
    enctype="multipart/form-data">
    @csrf
    <div class="modal-header">
        <h5 class="modal-title h6">{{ translate('Payment Approval') }}</h5>
        <button type="button" class="close" data-dismiss="modal">
        </button>
    </div>
    <div class="modal-body">
        <table class="table table-striped table-bordered">
            <tbody>
                <tr>
                    <td>{{ translate('Status') }}</td>
                    <td>
                        @if ($seller_package_payment->approval == 1)
                            <span class="badge badge-inline badge-success">{{ translate('Approved') }}</span>
                        @elseif ($seller_package_payment->approval == 3)
                            <span class="badge badge-inline badge-info">{{ translate('Proof Uploaded') }}</span>
                        @else
                            <span class="badge badge-inline badge-danger">{{ translate('Not Approved') }}</span>
                        @endif
                    </td>

                </tr>
                <tr>
                    <td>{{ translate('Seller Info') }}</td>
                    <td>
                        <div>{{ $seller_package_payment->user->name ?? translate('Deleted user') }}</div>
                        <div>{{ $seller_package_payment->user->email }}</div>
                        <div>{{ $seller_package_payment->user->phone }}</div>
                    </td>
                </tr>
                <tr>
                    <td>{{ translate('Package') }}</td>
                    <td>
                        <div>{{ $seller_package_payment->seller_package->name ?? translate('Deleted package') }}</div>
                        <div>Assigned Location: {{ $seller_package_payment->assigned_location_name ?? '—' }}</div>
                        @if ($seller_package_payment->assigned_location_trail)
                            <div class="text-muted small">{{ $seller_package_payment->assigned_location_trail }}</div>
                        @endif

                    </td>
                </tr>
                <tr>
                    <td>{{ translate('Amount') }}</td>
                    <td>{{ format_price($seller_package_payment->seller_package->amount) }}</td>
                </tr>
                <tr>
                    <td>{{ translate('Payment Method') }}</td>
                    <td>{{ $seller_package_payment->payment_method }}
                    </td>
                </tr>
                <tr>
                    <td>{{ translate('Payment Proof') }}</td>

                    <td class="d-flex align-items-center justify-content-center">
                        @if (!empty($seller_package_payment->payment_proof_upload))
                            @if (Str::startsWith($seller_package_payment->payment_proof_upload, 'http'))
                                <a href="{{ $seller_package_payment->payment_proof_upload }}" target="_blank">
                                    <img class="mw-100 mx-auto mb-4"
                                        onerror="this.onerror=null;this.src='{{ static_asset('/assets/img/placeholder.jpg') }}';"
                                        src="{{ $seller_package_payment->payment_proof_upload }}" height="200">
                                </a>
                            @else
                                <a href="{{ uploaded_asset($seller_package_payment->payment_proof_upload) }}"
                                    target="_blank">
                                    <img class="mw-100 mx-auto mb-4"
                                        onerror="this.onerror=null;this.src='{{ static_asset('/assets/img/placeholder.jpg') }}';"
                                        src="{{ uploaded_asset($seller_package_payment->payment_proof_upload) }}"
                                        height="200">
                                </a>
                            @endif
                        @else
                            <img class="mw-100 mx-auto mb-4"
                                onerror="this.onerror=null;this.src='{{ static_asset('/assets/img/placeholder.jpg') }}';"
                                src="{{ static_asset('/assets/img/placeholder.jpg') }}" height="200">
                        @endif
                    </td>

                </tr>
                </tr>
                <tr>
                    <td>{{ translate('Payment Transaction ID') }}</td>
                    <td>{{ $seller_package_payment->payment_proof_tran_id }}</td>
                </tr>
            </tbody>
        </table>

        <input type="hidden" name="id" value="{{ $seller_package_payment->id }}">

    </div>
    <div class="modal-footer">
        @if ($seller_package_payment->approval == 1 || $seller_package_payment->payment_proof_upload == null)
            <button type="submit" class="btn btn-primary" disabled>{{ translate('Approve') }}</button>
        @else
            <button type="submit" class="btn btn-primary">{{ translate('Approve') }}</button>
        @endif
        <button type="button" class="btn btn-light" data-dismiss="modal">{{ translate('Cancel') }}</button>
    </div>
</form>
