@extends('backend.layouts.app')

@section('content')
    <div class="card">
        <div class="card-header">
            <h5 class="mb-0 h6">{{ translate('Package Payments') }}</h5>
        </div>
        <div class="card-body">
            <table class="table aiz-table mb-0">
                <thead>
                    <tr>
                        <th>#</th>
                        <th>{{ translate('Seller') }}</th>
                        <th>{{ translate('Package') }}</th>
                        <th data-breakpoints="lg">{{ translate('Amount') }}</th>
                        <th data-breakpoints="lg">{{ translate('Payment Method') }}</th>
                        <th data-breakpoints="lg">{{ translate('Status') }}</th>
                        <th data-breakpoints="lg">{{ translate('Payment Tran ID') }}</th>
                        <th data-breakpoints="lg">{{ translate('Date') }}</th>
                        <th data-breakpoints="lg" width="15%" class="text-right">{{ translate('Options') }}</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach ($package_payments as $key => $package_payment)
                        <tr>
                            <td>{{ $key + 1 + ($package_payments->currentPage() - 1) * $package_payments->perPage() }}</td>
                            <td>
                                {{ $package_payment->user->name ?? translate('Deleted user') }}
                            </td>
                            <td>{{ $package_payment->seller_package->name ?? translate('Deleted package') }}</td>
                            <td>{{ format_price($package_payment->amount) }}</td>
                            <td>{{ $package_payment->payment_method }}</td>
                            <td>
                                @if ($package_payment->approval == 1)
                                    <span class="badge badge-inline badge-success">{{ translate('Approved') }}</span>
                                @elseif ($package_payment->approval == 3)
                                    <span class="badge badge-inline badge-info">{{ translate('Proof Uploaded') }}</span>
                                @else
                                    <span class="badge badge-inline badge-danger">{{ translate('Not Approved') }}</span>
                                @endif
                            </td>
                            <td>{{ $package_payment->payment_proof_tran_id }}</td>
                            <td>{{ $package_payment->created_at }}</td>
                            <td class="text-right">
                                <a href="javascript:void(0);" class="btn btn-soft-primary btn-icon btn-circle btn-sm"
                                    onclick="show_seller_package_payment_modal('{{ $package_payment->id }}');"
                                    title="{{ translate('Change Approval Status') }}">
                                    <i class="las la-eye"></i>
                                </a>
                            </td>
                        </tr>
                    @endforeach
                </tbody>
            </table>
            <div class="aiz-pagination">
                {{ $package_payments->appends(request()->input())->links() }}
            </div>
        </div>
    </div>
@endsection

@section('modal')
    <!-- package payment modal -->
    <div class="modal fade" id="package_payment_modal">
        <div class="modal-dialog">
            <div class="modal-content" id="package-payment-modal-content">

            </div>
        </div>
    </div>
@endsection

@section('script')
    <script type="text/javascript">
        function show_seller_package_payment_modal(id) {
            $.post('{{ route('admin.seller_packages.package_payment_modal') }}', {
                _token: '{{ @csrf_token() }}',
                id: id
            }, function(data) {
                $('#package-payment-modal-content').html(data);
                $('#package_payment_modal').modal('show', {
                    backdrop: 'static'
                });
            });
        }
    </script>
@endsection
