@php
    /** @var \App\Models\User $seller */
    $balance = (float) ($seller->current_balance ?? 0);

    // Show bank option only if user has bank details
    $hasBank =
        filled($seller->bank_name) ||
        filled($seller->bank_acc_name) ||
        filled($seller->bank_acc_no) ||
        filled($seller->bank_routing_no);
@endphp

<form action="{{ route('admin.pay_to_seller') }}" method="POST">
    @csrf
    <input type="hidden" name="user_id" value="{{ $seller->id }}">

    <div class="modal-header">
        <h5 class="modal-title h6">{{ translate('Pay to seller') }}</h5>
        <button type="button" class="close" data-dismiss="modal"></button>
    </div>

    <div class="modal-body">
        <table class="table table-striped table-bordered">
            <tbody>
                <tr>
                    @if ($balance >= 0)
                        <td>{{ translate('Due to seller') }}</td>
                        <td>{{ format_price($balance) }}</td>
                    @else
                        <td>{{ translate('Due from seller') }}</td>
                        <td>{{ format_price(abs($balance)) }}</td>
                    @endif
                </tr>

                @if ($hasBank)
                    <tr>
                        <td>{{ translate('Bank Name') }}</td>
                        <td>{{ $seller->bank_name ?? '—' }}</td>
                    </tr>
                    <tr>
                        <td>{{ translate('Bank Account Name') }}</td>
                        <td>{{ $seller->bank_acc_name ?? '—' }}</td>
                    </tr>
                    <tr>
                        <td>{{ translate('Bank Account Number') }}</td>
                        <td>{{ $seller->bank_acc_no ?? '—' }}</td>
                    </tr>
                    <tr>
                        <td>{{ translate('Bank Routing Number') }}</td>
                        <td>{{ $seller->bank_routing_no ?? '—' }}</td>
                    </tr>
                @endif
            </tbody>
        </table>

        @php $presetAmount = $balance >= 0 ? $balance : abs($balance); @endphp

        <div class="form-group row">
            <label class="col-md-3 col-from-label" for="amount">{{ translate('Amount') }}</label>
            <div class="col-md-9">
                <input type="number" lang="en" min="0" step="0.01" name="amount" id="amount"
                    value="{{ $presetAmount }}" class="form-control" required>
            </div>
        </div>

        <div class="form-group row">
            <label class="col-md-3 col-from-label" for="payment_option">{{ translate('Payment Method') }}</label>
            <div class="col-md-9">
                <select name="payment_option" id="payment_option" class="form-control aiz-selectpicker" required>
                    <option value="">{{ translate('Select Payment Method') }}</option>
                    <option value="cash">{{ translate('Cash') }}</option>
                    @if ($hasBank)
                        <option value="bank_payment">{{ translate('Bank Payment') }}</option>
                    @endif
                </select>
            </div>
        </div>

        <div class="form-group row" id="txn_div">
            <label class="col-md-3 col-from-label" for="txn_code">{{ translate('Txn Code') }}</label>
            <div class="col-md-9">
                <input type="text" name="txn_code" id="txn_code" class="form-control">
            </div>
        </div>
    </div>

    <div class="modal-footer">
        <button type="submit" class="btn btn-primary">
            {{ $balance > 0 ? translate('Pay') : translate('Clear due') }}
        </button>
        <button type="button" class="btn btn-light" data-dismiss="modal">{{ translate('Cancel') }}</button>
    </div>
</form>

<script>
    $(function() {
        function toggleTxnDiv() {
            const v = $('#payment_option').val();
            $('#txn_div').toggle(v === 'bank_payment');
        }
        $('#payment_option').on('change', toggleTxnDiv);
        toggleTxnDiv();
        AIZ.plugins.bootstrapSelect('refresh');
    });
</script>
