{{-- addon:multivendor::admin/sellers/profile_modal.blade.php --}}
@php
    /** @var \App\Models\User $seller */
    $hasGCash = ($seller->gcash_name || $seller->gcash_no);
    $hasBank  = ($seller->bank_name || $seller->bank_acc_name || $seller->bank_acc_no);
@endphp

<div class="modal-body">
    <div class="text-center">
        <span class="avatar avatar-xxl mb-3">
            <img src="{{ uploaded_asset($seller->avatar ?? null) }}"
                 onerror="this.onerror=null;this.src='{{ static_asset('assets/img/avatar-place.png') }}';">
        </span>
        <h1 class="h5 mb-1">{{ $seller->name ?? '—' }}</h1>
        <p class="text-sm text-muted">
            {{ $seller->seller_type ?? (optional($seller->seller_package)->name ?? translate('No Package')) }}
        </p>
    </div>
    <hr>

    {{-- About --}}
    <h6 class="mb-3">{{ translate('About') }} {{ $seller->name ?? '' }}</h6>
    <p class="mb-1"><i class="demo-pli-internet icon-lg icon-fw mr-1"></i>{{ $seller->email ?? '—' }}</p>
    <p class="mb-1"><i class="demo-pli-old-telephone icon-lg icon-fw mr-1"></i>{{ $seller->phone ?? '—' }}</p>
    <p class="mb-1"><i class="las la-map-marker-alt icon-lg icon-fw mr-1"></i>
        <span class="fw-600">{{ translate('Assigned Location') }}:</span> {{ $assignedName ?? '—' }}
    </p>

    {{-- Payout Info --}}
    <h6 class="mb-3 mt-4">{{ translate('Payout Info') }}</h6>

    @if ($hasGCash)
        <p class="mb-1 fw-600">{{ translate('GCash') }}</p>
        <p class="mb-1">{{ translate('GCash Name') }} : {{ $seller->gcash_name ?? '—' }}</p>
        <p class="mb-1">{{ translate('GCash Number') }} : {{ $seller->gcash_no ?? '—' }}</p>
    @elseif ($hasBank)
        <p class="mb-1 fw-600">{{ translate('Bank Account Payout') }}</p>
        <p class="mb-1">{{ translate('Bank Name') }} : {{ $seller->bank_name ?? '—' }}</p>
        <p class="mb-1">{{ translate('Account Name') }} : {{ $seller->bank_acc_name ?? '—' }}</p>
        <p class="mb-1">{{ translate('Account Number') }} : {{ $seller->bank_acc_no ?? '—' }}</p>
    @else
        <p class="text-muted mb-0">—</p>
    @endif
</div>
