@extends('addon:multivendor::seller.layouts.app')

@section('content')
    {{-- Second row: Recent Referrals, Order Status, Recent Orders --}}
    <div class="row mb-3">
        {{-- Recent Referrals --}}
        <div class="col-xl-3 col-md-6 mb-4">
            <div class="card overflow-hidden h-100 mb-0">
                <div class="card-body">
                    <div class="fs-16 fw-700">{{ translate('Recent Referrals') }}</div>
                    <ul class="list-group list-group-flush">
                        @forelse ($latestPackagePayments as $payment)
                            <li class="list-group-item d-flex justify-content-end px-0 py-3 lh-1-3">
                                <span class="flex-grow-1 minw-0">
                                    <div class="fw-700">{{ $payment->user->name ?? translate('Unknown') }}</div>
                                    <div class="opacity-60">
                                        {{ optional($payment->created_at)->toFormattedDateString() }}
                                    </div>
                                </span>
                            </li>
                        @empty
                            <li class="list-group-item px-0 py-3 lh-1-3">
                                <span class="opacity-60">{{ translate('No referrals yet.') }}</span>
                            </li>
                        @endforelse
                    </ul>
                </div>
            </div>
        </div>

        {{-- Order status summary --}}
        <div class="col-xl-6 col-md-6 mb-4">
            <div class="rounded-lg p-4 border mb-3 bg-light">
                <div class="py-1 d-flex align-items-center">
                    <svg xmlns="http://www.w3.org/2000/svg" width="24" height="20.727" viewBox="0 0 24 20.727">
                        <path id="shipping-truck"
                            d="M25,13.409v5.455a1.091,1.091,0,0,1-1.091,1.091H22.818a3.273,3.273,0,1,1-6.545,0H9.727a3.273,3.273,0,1,1-6.545,0H2.091A1.091,1.091,0,0,1,1,18.864V5.773A3.273,3.273,0,0,1,4.273,2.5h9.818a3.273,3.273,0,0,1,3.273,3.273V7.955h2.182a3.273,3.273,0,0,1,2.618,1.309l2.618,3.491a.665.665,0,0,1,.076.153l.065.12A1.091,1.091,0,0,1,25,13.409ZM7.545,19.955a1.091,1.091,0,1,0-1.091,1.091A1.091,1.091,0,0,0,7.545,19.955ZM15.182,5.773a1.091,1.091,0,0,0-1.091-1.091H4.273A1.091,1.091,0,0,0,3.182,5.773v12h.851a3.273,3.273,0,0,1,4.844,0h6.305Zm2.182,6.545h4.364l-1.309-1.745a1.091,1.091,0,0,0-.873-.436H17.364Zm3.273,7.636a1.091,1.091,0,1,0-1.091,1.091A1.091,1.091,0,0,0,20.636,19.955ZM22.818,14.5H17.364v3.033a3.273,3.273,0,0,1,4.6.24h.851Z"
                            transform="translate(-1 -2.5)" fill="#F0C05A" />
                    </svg>
                    <div class="flex-grow-1 fw-700 mx-4">{{ translate('Order Placed') }}</div>
                    <div class="fs-20 fw-600" style="color:#F0C05A">
                        {{ $orderPlacedCount }}
                    </div>
                </div>
            </div>

            <div class="rounded-lg p-4 border mb-3 bg-light">
                <div class="py-1 d-flex align-items-center">
                    <svg xmlns="http://www.w3.org/2000/svg" width="23.999" height="25.134" viewBox="0 0 23.999 25.134">
                        <g transform="translate(-41.293 -19.076)">
                            <path
                                d="M63.758,20.966V39.321c0,.054,0,.11-.008.163.01-.069.018-.135.028-.2a1.214,1.214,0,0,1-.082.3l.076-.184a1.7,1.7,0,0,1-.1.176c-.061.1.112-.122.051-.061-.023.023-.043.051-.066.074s-.041.038-.061.056c-.092.089.161-.1.048-.038-.059.033-.115.069-.176.1l.184-.076a1.184,1.184,0,0,1-.3.082l.2-.028a5.439,5.439,0,0,1-.576.008H58.56l.66,1.15a6.862,6.862,0,1,0-12.035-6.582,7.037,7.037,0,0,0-.732,2.656,6.91,6.91,0,0,0,.579,3.25,6.391,6.391,0,0,0,.339.673l.66-1.15H43.715c-.227,0-.464.015-.691-.008l.2.028a1.214,1.214,0,0,1-.3-.082l.184.076a1.7,1.7,0,0,1-.176-.1c-.1-.061.122.112.061.051-.023-.023-.051-.043-.074-.066s-.038-.041-.056-.061c-.089-.092.1.161.038.048-.033-.059-.069-.115-.1-.176l.076.184a1.214,1.214,0,0,1-.082-.3c.01.069.018.135.028.2a5.309,5.309,0,0,1-.008-.6V20.989c0-.054,0-.11.008-.163-.01.069-.018.135-.028.2a1.215,1.215,0,0,1,.082-.3l-.076.184a1.7,1.7,0,0,1,.1-.176c.061-.1-.112.122-.051.061.023-.023.043-.051.066-.074s.041-.038.061-.056c.092-.089-.161.1-.048.038.059-.033.115-.069.176-.1l-.184.076a1.184,1.184,0,0,1,.3-.082l-.2.028a6.185,6.185,0,0,1,.653-.008H63.4c.056,0,.11,0,.166.008l-.2-.028a1.215,1.215,0,0,1,.3.082l-.184-.076a1.7,1.7,0,0,1,.176.1c.1.061-.122-.112-.061-.051.023.023.051.043.074.066s.038.041.056.061c.089.092-.1-.161-.038-.048.033.059.069.115.1.176l-.076-.184a1.184,1.184,0,0,1,.082.3c-.01-.069-.018-.135-.028-.2,0,.051.005.1.008.143a.765.765,0,0,0,1.53,0A1.893,1.893,0,0,0,63.419,19.1H43.264a2.074,2.074,0,0,0-1.01.237A1.9,1.9,0,0,0,41.3,21V38.712a3.559,3.559,0,0,0,.1,1.242,1.915,1.915,0,0,0,1.216,1.175,2.017,2.017,0,0,0,.63.082h4.78a.772.772,0,0,0,.66-1.15,6.534,6.534,0,0,1-.349-.693l.076.184a6.2,6.2,0,0,1-.428-1.565c.01.069.018.135.028.2a6.223,6.223,0,0,1,0-1.629c-.01.069-.018.135-.028.2a6.2,6.2,0,0,1,.423-1.553l-.076.184a6.186,6.186,0,0,1,.413-.808c.079-.127.161-.255.25-.377l.069-.094c.01-.013.02-.025.031-.041.043-.061-.071.1-.069.089.013-.056.11-.135.148-.181a5.992,5.992,0,0,1,.63-.642c.054-.048.11-.094.166-.14l.092-.074c.087-.071-.158.117-.036.028s.245-.176.37-.257a6.1,6.1,0,0,1,.92-.484l-.184.076a6.173,6.173,0,0,1,1.553-.423l-.2.028a6.2,6.2,0,0,1,1.626,0l-.2-.028a6.2,6.2,0,0,1,1.553.423l-.184-.076a6.186,6.186,0,0,1,.808.413c.127.079.255.161.377.25l.094.069c.013.01.025.02.041.031.061.043-.1-.071-.089-.069.056.013.135.11.181.148a5.991,5.991,0,0,1,.642.63c.048.054.094.11.14.166.025.031.048.061.074.092.071.087-.117-.158-.028-.036s.176.245.257.37a6.1,6.1,0,0,1,.484.92l-.076-.184a6.173,6.173,0,0,1,.423,1.553c-.01-.069-.018-.135-.028-.2a6.335,6.335,0,0,1,0,1.629c.01-.069.018-.135.028-.2a6.171,6.171,0,0,1-.428,1.565l.076-.184a6.534,6.534,0,0,1-.349.693.771.771,0,0,0,.66,1.15h2.33c.841,0,1.68.008,2.521,0a1.891,1.891,0,0,0,1.879-1.866V20.966a.767.767,0,0,0-1.535,0Z"
                                transform="translate(0 -0.023)" fill="#7bc4c4" />
                        </g>
                    </svg>
                    <div class="flex-grow-1 fw-700 mx-4">{{ translate('Order Packed') }}</div>
                    <div class="fs-20 fw-600" style="color:#7BC4C4">
                        {{ $orderPackedCount }}
                    </div>
                </div>
            </div>

            <div class="rounded-lg p-4 border mb-3 bg-light">
                <div class="py-1 d-flex align-items-center">
                    <svg xmlns="http://www.w3.org/2000/svg" width="24" height="26.182" viewBox="0 0 24 26.182">
                        <path
                            d="M16,0,4,5.455V20.727l12,5.455,12-5.455V5.455Zm0,2.4,8.045,3.657L16,9.712,7.952,6.055ZM6.182,19.323V7.645l8.727,3.965V23.288Zm19.636,0-8.727,3.966V11.61l8.727-3.966Z"
                            transform="translate(-4)" fill="#91A8D0" />
                    </svg>
                    <div class="flex-grow-1 fw-700 mx-4">{{ translate('Shipped to Courier') }}</div>
                    <div class="fs-20 fw-600" style="color:#91A8D0">
                        {{ $shippedToCourierCount }}
                    </div>
                </div>
            </div>

            <div class="rounded-lg p-4 border mb-3 bg-light">
                <div class="py-1 d-flex align-items-center">
                    <svg xmlns="http://www.w3.org/2000/svg" width="24" height="26.182" viewBox="0 0 24 26.182">
                        <path
                            d="M16,0,4,5.455V20.727l12,5.455,12-5.455V5.455Zm0,2.4,8.045,3.657L16,9.712,7.952,6.055ZM6.182,19.323V7.645l8.727,3.965V23.288Zm19.636,0-8.727,3.966V11.61l8.727-3.966Z"
                            transform="translate(-4)" fill="#F0C05A" />
                    </svg>
                    <div class="flex-grow-1 fw-700 mx-4">{{ translate('In Transit') }}</div>
                    <div class="fs-20 fw-600" style="color:#F0C05A">
                        {{ $inTransitCount }}
                    </div>
                </div>
            </div>

            <div class="rounded-lg p-4 border mb-3 bg-light">
                <div class="py-1 d-flex align-items-center">
                    <svg xmlns="http://www.w3.org/2000/svg" width="24" height="26.182" viewBox="0 0 24 26.182">
                        <path
                            d="M16,0,4,5.455V20.727l12,5.455,12-5.455V5.455Zm0,2.4,8.045,3.657L16,9.712,7.952,6.055ZM6.182,19.323V7.645l8.727,3.965V23.288Zm19.636,0-8.727,3.966V11.61l8.727-3.966Z"
                            transform="translate(-4)" fill="#7BC4C4" />
                    </svg>
                    <div class="flex-grow-1 fw-700 mx-4">{{ translate('Out for Delivery') }}</div>
                    <div class="fs-20 fw-600" style="color:#7BC4C4">
                        {{ $outForDeliveryCount }}
                    </div>
                </div>
            </div>

            <div class="rounded-lg p-4 border bg-light">
                <div class="py-1 d-flex align-items-center">
                    <svg xmlns="http://www.w3.org/2000/svg" width="24" height="20.727" viewBox="0 0 24 20.727">
                        <path
                            d="M25,13.409v5.455a1.091,1.091,0,0,1-1.091,1.091H22.818a3.273,3.273,0,1,1-6.545,0H9.727a3.273,3.273,0,1,1-6.545,0H2.091A1.091,1.091,0,0,1,1,18.864V5.773A3.273,3.273,0,0,1,4.273,2.5h9.818a3.273,3.273,0,0,1,3.273,3.273V7.955h2.182a3.273,3.273,0,0,1,2.618,1.309l2.618,3.491a.665.665,0,0,1,.076.153l.065.12A1.091,1.091,0,0,1,25,13.409ZM7.545,19.955a1.091,1.091,0,1,0-1.091,1.091A1.091,1.091,0,0,0,7.545,19.955ZM15.182,5.773a1.091,1.091,0,0,0-1.091-1.091H4.273A1.091,1.091,0,0,0,3.182,5.773v12h.851a3.273,3.273,0,0,1,4.844,0h6.305Zm2.182,6.545h4.364l-1.309-1.745a1.091,1.091,0,0,0-.873-.436H17.364Zm3.273,7.636a1.091,1.091,0,1,0-1.091,1.091A1.091,1.091,0,0,0,20.636,19.955ZM22.818,14.5H17.364v3.033a3.273,3.273,0,0,1,4.6.24h.851Z"
                            transform="translate(-1 -2.5)" fill="#FF6F61" />
                    </svg>
                    <div class="flex-grow-1 fw-700 mx-4">{{ translate('Order Delivered') }}</div>
                    <div class="fs-20 fw-600" style="color:#FF6F61">
                        {{ $deliveredCount }}
                    </div>
                </div>
            </div>
        </div>

        {{-- Recent Orders --}}
        <div class="col-xl-3 col-md-6 mb-4">
            <div class="card overflow-hidden h-100 mb-0">
                <div class="card-body">
                    <div class="fs-16 fw-700 border-bottom pb-3">{{ translate('Recent Orders') }}</div>
                    <ul class="list-group list-group-flush">
                        @forelse ($recentOrders as $order)
                            <li class="list-group-item d-flex justify-content-end px-0 py-3 lh-1-3">
                                <span class="flex-grow-1 minw-0">
                                    <div class="fw-700">{{ $order->code }}</div>
                                    <div class="opacity-60">
                                        {{ optional($order->created_at)->toFormattedDateString() }}
                                    </div>
                                </span>
                            </li>
                        @empty
                            <li class="list-group-item px-0 py-3 lh-1-3">
                                <span class="opacity-60">{{ translate('No orders yet.') }}</span>
                            </li>
                        @endforelse
                    </ul>
                </div>
            </div>
        </div>

        {{-- Earnings --}}
        <div class="col-lg-12 col-12 d-flex flex-column justify-content-end">
            <div class="row all-earnings mb-4">
                <div class="col-12">
                    <div class="shadow-xl rounded-lg p-4">
                        <div class="row align-items-stretch">
                            {{-- Net Earnings --}}
                            <div class="col-md-6 mb-3 mb-md-0 d-flex">
                                <div class="rounded-lg p-4 d-flex flex-column justify-content-between w-100"
                                    style="background-color:#f5a100;">
                                    <div>
                                        <div class="h5 fw-500 text-white">{{ translate('Your Earnings') }}</div>
                                        <div class="h2 fw-700 text-white">{{ format_price($allTime) }}</div>
                                    </div>
                                </div>
                            </div>

                            {{-- Share Links --}}
                            <div class="col-md-6 d-flex">
                                <div
                                    class="shadow-sm rounded-lg p-4 bg-white w-100 d-flex flex-column flex-lg-row align-items-center justify-content-between">
                                    <div>
                                        <h5 class="fw-700 text-dark mb-1">
                                            {{ translate('Share Your Links') }}
                                        </h5>
                                        <small class="text-muted">
                                            {{ translate('Copy and share your shop and referral links.') }}
                                        </small>
                                    </div>

                                    <div class="d-grid d-lg-flex gap-2 mt-3 mt-lg-0 w-100 w-lg-auto">
                                        <a href="#"
                                            class="btn btn-outline-secondary border-gray-300 d-flex justify-content-center align-items-center px-3 py-2 bg-warning fw-500 me-0 me-lg-2 w-100 w-lg-auto copy-shop-link"
                                            data-user-id="{{ Auth::id() }}"
                                            title="{{ translate('Share My Shop Link') }}">
                                            <i class="las la-share-alt me-2"></i>{{ translate('Share My Shop Link') }}
                                        </a>
                                        <a href="#"
                                            class="btn btn-outline-secondary border-gray-300 d-flex justify-content-center align-items-center px-3 py-2 bg-warning fw-500 w-100 w-lg-auto copy-referral-link"
                                            data-user-id="{{ Auth::id() }}"
                                            title="{{ translate('Share My Referral Link') }}">
                                            <i
                                                class="las la-network-wired me-2"></i>{{ translate('Share My Referral Link') }}
                                        </a>
                                    </div>
                                </div>
                            </div>
                            {{-- /Share Links --}}
                        </div>
                    </div>
                </div>
            </div>
        </div>

    </div>
@endsection

@section('script')
    <script>
        // Clipboard + Share using HOMEPAGE_URL
        const BASE_URL = "{{ rtrim(env('HOMEPAGE_URL', config('app.url') ?: url('/')), '/') }}";
        const CURRENT_USER_ID = {{ (int) Auth::id() }};

        function copyTextToClipboard(text) {
            if (navigator.clipboard && window.isSecureContext) return navigator.clipboard.writeText(text);
            return new Promise((resolve, reject) => {
                try {
                    const ta = document.createElement('textarea');
                    ta.value = text;
                    ta.style.position = 'fixed';
                    ta.style.opacity = '0';
                    document.body.appendChild(ta);
                    ta.focus();
                    ta.select();
                    const ok = document.execCommand('copy');
                    document.body.removeChild(ta);
                    ok ? resolve() : reject(new Error('execCommand failed'));
                } catch (e) {
                    reject(e);
                }
            });
        }

        function copyShopLink(userId) {
            const uid = userId || CURRENT_USER_ID;
            const url = BASE_URL + "/shop/?sellerid=" + encodeURIComponent(uid);
            return copyTextToClipboard(url)
                .then(() => {
                    $.get("{{ route('link.copied') }}");
                    AIZ.plugins.notify('success', 'Shop link copied successfully!');
                })
                .catch(() => {
                    AIZ.plugins.notify('danger', 'Failed to copy link.');
                });
        }

        function copyReferralLink(userId) {
            const uid = userId || CURRENT_USER_ID;
            const url = BASE_URL + "/referral/?sellerid=" + encodeURIComponent(uid);
            return copyTextToClipboard(url)
                .then(() => {
                    $.get("{{ route('link.copied') }}");
                    AIZ.plugins.notify('success', 'Referral link copied successfully!');
                })
                .catch(() => {
                    AIZ.plugins.notify('danger', 'Failed to copy link.');
                });
        }

        $(document).on('click', '.copy-shop-link', function(e) {
            e.preventDefault();
            copyShopLink($(this).data('user-id'));
        });

        $(document).on('click', '.copy-referral-link', function(e) {
            e.preventDefault();
            copyReferralLink($(this).data('user-id'));
        });
    </script>
@endsection
