@extends('addon:multivendor::seller.layouts.app')

@section('content')
    @php
        $balance = isset($currentBalance) ? (float) $currentBalance : (float) (Auth::user()->current_balance ?? 0);
    @endphp

    <div class="aiz-titlebar mt-2 mb-4">
        <div class="row align-items-center">
            <div class="col-md-6">
                <h1 class="h3">{{ translate('Payout requests') }}</h1>
            </div>
        </div>
    </div>

    @if (!$canRequest)
        <div class="alert alert-warning">
            {{ translate('Please configure at least one payout method (GCash or Bank) before sending a payout request.') }}
            <a href="{{ route('seller.payout_settings') }}" class="alert-link">{{ translate('Open settings') }}</a>.
        </div>
    @endif

    <div class="row gutters-10">
        <div class="col-md-4 mb-3 ml-auto">
            <div class="bg-grad-1 text-white rounded-lg overflow-hidden">
                <span
                    class="size-30px rounded-circle mx-auto bg-soft-primary d-flex align-items-center justify-content-center mt-3">
                    <i class="las la-money-bill-wave la-2x text-white"></i>
                </span>
                <div class="px-3 pt-3 pb-3">
                    <div class="h4 fw-700 text-center">{{ format_price($balance) }}</div>
                    <div class="opacity-50 text-center">{{ translate('Pending Balance') }}</div>
                </div>
            </div>
        </div>

        <div class="col-md-4 mb-3 mr-auto">
            <div class="p-3 rounded mb-3 text-center bg-white shadow-sm hov-shadow-lg border border-gray-200 has-transition {{ $canRequest ? 'c-pointer' : 'opacity-50' }}"
                @if ($canRequest) onclick="withdraw_request_modal()" @endif
                @if (!$canRequest) title="{{ translate('Configure payout settings first') }}" @endif>
                <span
                    class="size-60px rounded-circle mx-auto bg-secondary d-flex align-items-center justify-content-center mb-3">
                    <i class="las la-plus la-3x text-white"></i>
                </span>
                <div class="fs-18 text-primary">{{ translate('Send payout request') }}</div>
            </div>
        </div>
    </div>

    <div class="card">
        <div class="card-header">
            <h5 class="mb-0 h6">{{ translate('Payout requests history') }}</h5>
        </div>
        <div class="card-body">
            <table class="table aiz-table mb-0">
                <thead>
                    <tr>
                        <th>#</th>
                        <th>{{ translate('Date') }}</th>
                        <th>{{ translate('Amount') }}</th>
                        <th data-breakpoints="lg">{{ translate('Status') }}</th>
                        <th data-breakpoints="lg">{{ translate('Message') }}</th>
                    </tr>
                </thead>
                <tbody>
                    @forelse ($payout_requests as $key => $payout_request)
                        <tr>
                            <td>{{ $key + 1 }}</td>
                            <td>{{ date('d-m-Y', strtotime($payout_request->created_at)) }}</td>
                            <td>{{ format_price($payout_request->requested_amount) }}</td>
                            <td>
                                @if ($payout_request->status === 'paid')
                                    <span class="badge badge-inline badge-success">{{ translate('Paid') }}</span>
                                @else
                                    <span class="badge badge-inline badge-info">{{ translate('Pending') }}</span>
                                @endif
                            </td>
                            <td>{{ $payout_request->seller_note }}</td>
                        </tr>
                    @empty
                        <tr>
                            <td colspan="5" class="text-center text-muted">{{ translate('No payout requests yet.') }}
                            </td>
                        </tr>
                    @endforelse
                </tbody>
            </table>
            <div class="aiz-pagination">
                {{ $payout_requests->links() }}
            </div>
        </div>
    </div>
@endsection

@section('modal')
    <div class="modal fade" id="withdraw_request_modal" tabindex="-1" role="dialog" aria-labelledby="withdrawRequestLabel"
        aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="withdrawRequestLabel">{{ translate('Send A Withdraw Request') }}</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close"></button>
                </div>

                @if ($balance > 5)
                    <form action="{{ route('seller.payouts.request.store') }}" method="POST">
                        @csrf
                        <div class="modal-body gry-bg px-3 pt-3">
                            {{-- choose method (only show enabled ones) --}}
                            <div class="row mb-3">
                                <div class="col-md-3">
                                    <label>{{ translate('Payout Method') }} <span class="text-danger">*</span></label>
                                </div>
                                <div class="col-md-9">
                                    @if ($gcashEnabled)
                                        <div class="mb-2">
                                            <label class="aiz-megabox d-block">
                                                <input type="radio" name="payment_method" value="gcash" required>
                                                <span class="d-block p-3 aiz-megabox-elem">
                                                    <span class="d-block fw-600">{{ translate('GCash') }}</span>
                                                    <small class="d-block opacity-70">
                                                        {{ $user->gcash_name }} —
                                                        {{ \Illuminate\Support\Str::mask($user->gcash_no, '*', 0, max(strlen($user->gcash_no) - 4, 0)) }}
                                                    </small>
                                                </span>
                                            </label>
                                        </div>
                                    @endif

                                    @if ($bankEnabled)
                                        <div>
                                            <label class="aiz-megabox d-block">
                                                <input type="radio" name="payment_method" value="bank" required>
                                                <span class="d-block p-3 aiz-megabox-elem">
                                                    <span class="d-block fw-600">{{ translate('Bank') }}</span>
                                                    <small class="d-block opacity-70">
                                                        {{ $user->bank_name }} — {{ $user->bank_acc_name }} —
                                                        {{ \Illuminate\Support\Str::mask($user->bank_acc_no, '*', 0, max(strlen($user->bank_acc_no) - 4, 0)) }}
                                                    </small>
                                                </span>
                                            </label>
                                            <small class="form-text text-danger">
                                                {{ format_price((float) (get_setting('payout_fee_amount') ?? 25)) }}
                                                {{ translate('charge will be applied upon successful payout transactions.') }}
                                            </small>
                                        </div>
                                    @endif
                                </div>
                            </div>

                            <div class="row">
                                <div class="col-md-3">
                                    <label>{{ translate('Amount') }} <span class="text-danger">*</span></label>
                                </div>
                                <div class="col-md-9">
                                    <input type="number" lang="en" class="form-control mb-3" name="amount"
                                        min="1" max="{{ $balance }}" placeholder="{{ translate('Amount') }}"
                                        required>
                                </div>
                            </div>

                            <div class="row">
                                <div class="col-md-3">
                                    <label>{{ translate('Message') }}</label>
                                </div>
                                <div class="col-md-9">
                                    <textarea name="message" rows="6" class="form-control mb-3"></textarea>
                                </div>
                            </div>

                            <div class="form-group text-right">
                                <button type="submit" class="btn btn-sm btn-primary">{{ translate('Send') }}</button>
                            </div>
                        </div>
                    </form>
                @else
                    <div class="modal-body gry-bg px-3 pt-3">
                        <div class="p-5 heading-3">
                            {{ translate('You do not have enough balance to send withdraw request') }}
                        </div>
                    </div>
                @endif

            </div>
        </div>
    </div>
@endsection

@section('script')
    <script>
        function withdraw_request_modal() {
            $('#withdraw_request_modal').modal('show');
        }
    </script>
@endsection
