@extends('addon:multivendor::seller.layouts.app')

@section('content')

    <div class="card">
        <div class="card-header">
            <h1 class="h2 fs-18 mb-0">{{ translate('Order DetailsLLL') }}</h1>
        </div>
        <div class="card-header">
            <div class="flex-grow-1 row">
                <div class="col-md mb-3">
                    <div>
                        <div class="fs-15 fw-600 mb-2">{{ translate('Customer info') }}</div>
                        <div><span class="opacity-80 mr-2 ml-0">{{ translate('Name') }}:</span>
                            {{ $order->name ?? '' }}</div>
                        <div><span class="opacity-80 mr-2 ml-0">{{ translate('Email') }}:</span>
                            {{ $order->email ?? '' }}</div>
                        <div><span class="opacity-80 mr-2 ml-0">{{ translate('Phone') }}:</span>
                            {{ $order->phone ?? '' }}</div>
                    </div>
                </div>
                <div class="col-md-3 ml-auto mr-0 mb-3">
                    <label>{{ translate('Payment Status') }}</label>:
                    @if ($order->payment_status == 'paid')
                        <span class="badge badge-inline badge-success">{{ translate('Paid') }}</span>
                    @else
                        <span class="badge badge-inline badge-danger">{{ translate('Unpaid') }}</span>
                    @endif

                </div>
                <div class="col-md-3 mb-3">
                    <label>{{ translate('Delivery Status') }}</label>:
                    <span class="text-capitalize">{{ translate(str_replace('_', ' ', $order->delivery_status)) }}</span>

                </div>
            </div>
        </div>
        <div class="card-header">
            <div class="flex-grow-1 row align-items-start">
                <div class="col-md-auto w-md-250px">
                    <h5 class="fs-14 mb-3">{{ translate('Shipping address') }}</h5>
                    <address class="">
                        {{ $order->shipping_address }}
                    </address>
                </div>
                <div class="col-md-auto w-md-250px">
                    <h5 class="fs-14 mb-3">{{ translate('Billing address') }}</h5>
                    <address class="">
                        {{ $order->billing_address }}
                    </address>
                </div>
                <div class="col-md-4 col-xl-3 ml-auto mr-0">
                    <table class="table table-borderless table-sm">
                        <tbody>
                            <tr>
                                <td class="">{{ translate('Order code') }}</td>
                                <td class="text-right text-info fw-700">{{ $order->combined_order->code }}</td>
                            </tr>
                            <tr>
                                <td class="">{{ translate('Order Date') }}</td>
                                <td class="text-right fw-700">{{ $order->created_at->format('d.m.Y') }}</td>
                            </tr>
                            <tr>
                                <td class="">{{ translate('Delivery type') }}</td>
                                <td class="text-right fw-700">
                                    {{ ucfirst(str_replace('_', ' ', $order->delivery_type)) }}
                                </td>
                            </tr>
                            <tr>
                                <td class="">{{ translate('Payment method') }}</td>
                                <td class="text-right fw-700">{{ ucfirst(str_replace('_', ' ', $order->payment_type)) }}
                                </td>
                            </tr>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>

        <div class="card-body">
            <table class="aiz-table table-bordered">
                <thead>
                    <tr class="">
                        <th class="text-center" width="5%" data-breakpoints="lg">#</th>
                        <th width="40%">{{ translate('Product') }}</th>
                        <th class="text-center" data-breakpoints="lg">{{ translate('Qty') }}</th>
                        <th class="text-center" data-breakpoints="lg">{{ translate('Unit Price') }}</th>
                        <th class="text-center" data-breakpoints="lg">{{ translate('Total') }}</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach ($order->orderDetails as $key => $orderDetail)
                        <tr>
                            <td>{{ $key + 1 }}</td>
                            <td>
                                @if ($orderDetail->product != null)
                                    <div class="media">
                                        <img src="{{ uploaded_asset($orderDetail->product->thumbnail_img) }}"
                                            class="size-60px mr-3">
                                        <div class="media-body">
                                            <h4 class="fs-14 fw-400">{{ $orderDetail->product->name }}</h4>
                                            @if ($orderDetail->variation)
                                                <div>
                                                    @foreach ($orderDetail->variation->combinations as $combination)
                                                        <span class="mr-2">
                                                            <span
                                                                class="opacity-50">{{ $combination->attribute->name }}</span>:
                                                            {{ $combination->attribute_value->name }}
                                                        </span>
                                                    @endforeach
                                                </div>
                                            @endif
                                        </div>
                                    </div>
                                @else
                                    <strong>{{ translate('Product Unavailable') }}</strong>
                                @endif
                            </td>
                            <td class="text-center">{{ $orderDetail->quantity }}</td>
                            <td class="text-center">{{ format_price($orderDetail->price) }}</td>
                            <td class="text-center">{{ format_price($orderDetail->total) }}</td>
                        </tr>
                    @endforeach
                </tbody>
            </table>
            <div class="row">
                <div class="col-xl-4 col-md-6 ml-auto mr-0">
                    <table class="table">
                        <tbody>
                            <tr>
                                <td><strong class="">{{ translate('Sub Total') }} :</strong></td>
                                <td>
                                    {{ format_price($order->orderDetails->sum('total')) }}
                                </td>
                            </tr>
                            <tr>
                                <td><strong class=""> {{ translate('Shipping') }} :</strong></td>
                                <td>{{ format_price($order->shipping_cost) }}</td>
                            </tr>
                            <tr>
                                <td><strong class="">{{ translate('TOTAL') }} :</strong></td>
                                <td class=" h4">
                                    {{ format_price($order->grand_total) }}
                                </td>
                            </tr>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
        @if (addon_is_activated('multi_vendor') && optional(optional($order->shop)->user)->user_type != 'admin')
            <div class="card">
                <div class="card-header">
                    <h3 class="fs-16 mb-0">{{ translate('Earning History') }}</h3>
                </div>
                <div class="card-body">
                    <table class="table aiz-table mb-0">
                        <thead>
                            <tr>
                                <th>#</th>
                                <th>{{ translate('Seller Earning') }}</th>
                                <th data-breakpoints="lg">{{ translate('Details') }}</th>
                                <th class="text-center">{{ translate('Type') }}</th>
                                <th data-breakpoints="lg" class="text-right">{{ translate('Calculated At') }}</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach ($order->commission_histories()->latest()->get() as $history)
                                <tr>
                                    <td>{{ $key + 1 }}</td>
                                    <td>{{ format_price($history->seller_earning) }}</td>
                                    <td>{{ $history->details }}</td>
                                    <td class="text-center">
                                        @if ($history->type == 'Added')
                                            <span
                                                class="badge badge-inline badge-success">{{ translate($history->type) }}</span>
                                        @else
                                            <span
                                                class="badge badge-inline badge-danger">{{ translate($history->type) }}</span>
                                        @endif
                                    </td>
                                    <td class="text-right">{{ $history->created_at }}</td>
                                </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>
            </div>
        @endif
    </div>
@endsection

@section('script')
    <script type="text/javascript">
        $('#update_delivery_status').on('change', function() {
            var order_id = {{ $order->id }};
            var status = $('#update_delivery_status').val();
            $.post('{{ route('seller.orders.update_delivery_status') }}', {
                _token: '{{ @csrf_token() }}',
                order_id: order_id,
                status: status
            }, function(data) {
                AIZ.plugins.notify('success', '{{ translate('Delivery status has been updated') }}');
            });
        });

        $('#update_payment_status').on('change', function() {
            var order_id = {{ $order->id }};
            var status = $('#update_payment_status').val();
            $.post('{{ route('seller.orders.update_payment_status') }}', {
                _token: '{{ @csrf_token() }}',
                order_id: order_id,
                status: status
            }, function(data) {
                AIZ.plugins.notify('success', '{{ translate('Payment status has been updated') }}');
            });
        });
    </script>
@endsection
