    <form action="{{ route('seller.package.package_payment_proof') }}" method="POST">
        @csrf
        <div class="modal-header">
            <h5 class="modal-title h6">{{ translate('Upload Payment') }}</h5>
            <button type="button" class="close" data-dismiss="modal"></button>
        </div>

        <input type="hidden" name="transaction_id" value="{{ $transaction_id }}">
        <input type="hidden" name="seller_package_id" value="{{ $seller_package_id }}">

        <div class="modal-body">
            <div class="form-group">
                <label class="col-form-label">{{ translate('Payment Method') }}</label>
                <select name="payment_method" class="form-control aiz-selectpicker" data-live-search="true" required>
                    @foreach ($manual_payment_methods as $m)
                        <option value="{{ $m->heading }}">{{ $m->heading }}</option>
                    @endforeach
                </select>
            </div>

            <div class="form-group">
                <label class="col-form-label">{{ translate('Payment Proof') }}</label>
                <div class="input-group" data-toggle="aizuploader" data-type="image">
                    <div class="input-group-prepend">
                        <div class="input-group-text bg-soft-secondary font-weight-medium">{{ translate('Browse') }}
                        </div>
                    </div>
                    <div class="form-control file-amount">{{ translate('Choose file') }}</div>
                    <input type="hidden" name="payment_proof_upload" class="selected-files">
                </div>
                <div class="file-preview box sm"></div>
                @error('payment_proof_upload')
                    <div class="text-danger small mt-1">{{ $message }}</div>
                @enderror
            </div>
        </div>

        <div class="modal-footer">
            <button type="submit" class="btn btn-primary">{{ translate('Submit Proof') }}</button>
        </div>
    </form>

    @section('script')
        <script type="text/javascript">
            function select_payment_method_modal(id) {
                $.post('{{ route('seller.package.package_payment_modal') }}', {
                    _token: '{{ csrf_token() }}',
                    id: id
                }, function(data) {
                    $('#seller-package-payment-modal-content').html(data);
                    $('#package_payment_modal').modal('show', {
                        backdrop: 'static'
                    });
                });
            }

            @if (session('package_payment_modal_id'))
                $(function() {
                    select_payment_method_modal({{ (int) session('package_payment_modal_id') }});
                });
            @endif
        </script>
    @endsection
