@extends('addon:multivendor::seller.layouts.app')

@section('content')
    <div class="card">
        <form action="{{ route('seller.referrals') }}" method="GET">
            <div class="card-header row gutters-5">
                <div class="col text-center text-md-left">
                    <h5 class="mb-md-0 h6">{{ translate('All Referrals') }}</h5>
                </div>
                <div class="col-md-3">
                    <div class="form-group mb-0">
                        <input type="text" class="form-control form-control-sm aiz-date-range" id="search"
                            name="date_range"@isset($date_range) value="{{ $date_range }}" @endisset
                            placeholder="{{ translate('Daterange') }}" autocomplete="off">
                    </div>
                </div>
                <div class="col-auto">
                    <button type="submit" class="btn btn-sm btn-primary">{{ translate('Filter') }}</button>
                </div>
            </div>
        </form>
        {{-- <div class="card-body">
            <table class="table aiz-table mb-0">
                <thead>
                    <tr>
                        <th>#</th>
                        <th data-breakpoints="lg">{{ translate('Referred Seller') }}</th>
                        <th>{{ translate('Package Payment') }}</th>
                        <th>{{ translate('Your Earning') }}</th>
                        <th>{{ 'Seller Type' }}</th>
                        <th data-breakpoints="lg">{{ translate('Calculated At') }}</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach ($referrals as $key => $referral)
                        <tr>
                            <td>{{ $key + 1 }}</td>
                            <td>{{ $referral->name }}</td>
                            <td></td>
                            <td></td>
                            <td>{{ $referral->seller_type }}</td>
                            <td>{{ $referral->created_at }}</td>
                        </tr>
                    @endforeach
                </tbody>
            </table>
            <div class="aiz-pagination mt-4">
                {{ $referrals->links() }}
            </div>
        </div> --}}
        <div class="card-body">
            <table class="table aiz-table mb-0">
                <thead>
                    <tr>
                        <th>#</th>
                        <th data-breakpoints="lg">{{ translate('Referred Seller') }}</th>
                        <th>{{ translate('Package') }}</th>
                        <th>{{ translate('Payment Status') }}</th>
                        <th data-breakpoints="lg">{{ translate('Calculated At') }}</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach ($referrals as $key => $referral)
                        <tr>
                            <td>{{ $key + 1 }}</td>
                            <td>{{ $referral->name }}</td>
                            <td>
                                {{ optional(optional($referral->sellerPackagePayment)->seller_package)->name ?? translate('N/A') }}
                            </td>
                            <td>
                                @if ($referral->sellerPackagePayment && $referral->sellerPackagePayment->approval == 1)
                                    <span class="badge badge-inline badge-success">{{ translate('Paid') }}</span>
                                @else
                                    <span class="badge badge-inline badge-danger">{{ translate('Not Paid') }}</span>
                                @endif
                            </td>
                            <td>{{ $referral->created_at }}</td>
                        </tr>
                    @endforeach
                </tbody>
            </table>
            <div class="aiz-pagination mt-4">
                {{ $referrals->links() }}
            </div>
        </div>

    </div>
@endsection
