<?php

namespace App\Http\Controllers;

use Spatie\Permission\Traits\HasRoles;
use Illuminate\Http\Request;
use App\Models\Role;
use App\Models\User;
use Hash;

class MerchantController extends Controller
{
  public function __construct()
  {
    $this->middleware(['permission:show_merchants'])->only('index');
    $this->middleware(['permission:add_merchants'])->only('create');
    $this->middleware(['permission:edit_merchants'])->only('edit');
    $this->middleware(['permission:delete_merchants'])->only('destroy');
  }

  public function index()
  {
    $users = User::where('user_type', 'merchant')->latest()->paginate(10);
    return view('backend.merchants.index', compact('users'));
  }

  public function create()
  {
    $roles = Role::latest()->get();
    return view('backend.merchants.create', compact('roles'));
  }

  public function store(Request $request)
  {
    if (User::where('email', $request->email)->first() == null) {
      $admin = User::where('user_type', 'admin')->first();
      $user             = new User;
      $user->name       = $request->name;
      $user->email      = $request->email;
      $user->phone      = $request->mobile;
      $user->user_type  = "merchant";
      $user->password   = Hash::make($request->password);
      $user->role_id    = 3;
      $user->save();

      $user->assignRole('merchant');

      flash(translate('Merchant has been created successfully'))->success();
      return redirect()->route('merchants.index');
    }

    flash(translate('Email already used'))->error();
    return back();
  }


  public function show($id)
  {
    //
  }

  public function edit($id)
  {
    $user = User::findOrFail(decrypt($id));
    $roles = Role::latest()->get();
    return view('backend.merchants.edit', compact('user', 'roles'));
  }

  public function update(Request $request, $id)
  {
    $user             = User::findOrFail($id);
    $user->name       = $request->name;
    $user->email      = $request->email;
    $user->phone      = $request->mobile;
    $user->role_id    = 3;

    if (strlen($request->password) > 0) {
      $user->password = Hash::make($request->password);
    }

    $user->save();

    flash(translate('Merchant has been updated successfully'))->success();
    return redirect()->route('merchants.index');
  }

  public function destroy($id)
  {
    User::destroy($id);
    flash(translate('Merchant has been deleted successfully'))->success();
    return redirect()->route('merchants.index');
  }
}
