<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class SellerPackagePayment extends Model
{
  protected $casts = [
    'seller_assign_location' => 'integer',
  ];

  // Optional: expose computed fields in JSON
  protected $appends = ['assigned_location_name', 'assigned_location_trail'];

  public function user()
  {
    return $this->belongsTo(User::class);
  }
  public function seller_package()
  {
    return $this->belongsTo(SellerPackage::class, 'seller_package_id');
  }

  // Requested chain (from form)
  public function requestedRegion()
  {
    return $this->belongsTo(Region::class,   'requested_region_id');
  }
  public function requestedState()
  {
    return $this->belongsTo(State::class,    'requested_state_id');
  }
  public function requestedCity()
  {
    return $this->belongsTo(City::class,     'requested_city_id');
  }
  public function requestedBarangay()
  {
    return $this->belongsTo(Barangay::class, 'requested_barangay_id');
  }

  // Assigned leaf (type depends on geographic_level)
  public function assignedRegion()
  {
    return $this->belongsTo(Region::class,   'seller_assign_location');
  }
  public function assignedState()
  {
    return $this->belongsTo(State::class,    'seller_assign_location');
  }
  public function assignedCity()
  {
    return $this->belongsTo(City::class,     'seller_assign_location');
  }
  public function assignedBarangay()
  {
    return $this->belongsTo(Barangay::class, 'seller_assign_location');
  }

  // Single-line name for the assigned leaf
  public function getAssignedLocationNameAttribute(): ?string
  {
    $level = (int)($this->geographic_level ?? optional($this->seller_package)->geographic_level ?? 0);

    switch ($level) {
      case 1:
        return optional($this->assignedBarangay)->name
          ?? optional($this->assignedCity)->name
          ?? null;
      case 2:
        return optional($this->assignedCity)->name ?? null;
      case 3:
        return optional($this->assignedState)->name ?? null;
      case 4:
        return optional($this->assignedRegion)->name ?? null;
      default:
        return optional($this->assignedBarangay)->name
          ?? optional($this->assignedCity)->name
          ?? optional($this->assignedState)->name
          ?? optional($this->assignedRegion)->name
          ?? null;
    }
  }

  // Optional: human-readable trail using requested chain
  public function getAssignedLocationTrailAttribute(): ?string
  {
    $parts = [];
    if ($this->requestedBarangay) $parts[] = $this->requestedBarangay->name;
    if ($this->requestedCity)     $parts[] = $this->requestedCity->name;
    if ($this->requestedState)    $parts[] = $this->requestedState->name;
    if ($this->requestedRegion)   $parts[] = $this->requestedRegion->name;

    return $parts ? implode(', ', $parts) : null;
  }
}
