<?php

namespace App\Notifications;

use Illuminate\Bus\Queueable;
use Illuminate\Notifications\Messages\MailMessage;
use Illuminate\Notifications\Notification;

class SellerReferralNewUserPaymentUploadNotification extends Notification
{
  use Queueable;
  public $shop;

  /**
   * Create a new notification instance.
   *
   * @return void
   */
  public function __construct($shop)
  {
    $this->shop = $shop;
  }

  /**
   * Get the notification's delivery channels.
   *
   * @param  mixed  $notifiable
   * @return array
   */
  public function via($notifiable)
  {
    return ['mail'];
  }

  /**
   * Get the mail representation of the notification.
   *
   * @param  mixed  $notifiable
   * @return \Illuminate\Notifications\Messages\MailMessage
   */
  public function toMail($notifiable)
  {

    return (new MailMessage)
      ->subject('Congratulations!')
      ->greeting('Hello ' . $notifiable->name . '!')
      ->line('Your payment has been confirmed, and your account is currently being processed for activation and approval.')
      ->line('We’ll send you an email once your account has been activated.');
  }

  /**
   * Get the array representation of the notification.
   *
   * @param  mixed  $notifiable
   * @return array
   */
  public function toArray($notifiable)
  {
    return [
      //
    ];
  }
}
