<?php

namespace App\Notifications;

use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Notifications\Messages\MailMessage;
use Illuminate\Notifications\Notification;

class SellerReferralRegistrationNotification extends Notification
{
  use Queueable;
  public $shop;

  /**
   * Create a new notification instance.
   *
   * @return void
   */
  public function __construct($shop)
  {
    $this->shop = $shop;
  }

  /**
   * Get the notification's delivery channels.
   *
   * @param  mixed  $notifiable
   * @return array
   */
  public function via($notifiable)
  {
    return ['mail'];
  }

  /**
   * Get the mail representation of the notification.
   *
   * @param  mixed  $notifiable
   * @return \Illuminate\Notifications\Messages\MailMessage
   */
  public function toMail($notifiable)
  {
    $url = route('login');
    $siteName = trim(strip_tags((string) (get_setting('site_name') ?? config('app.name'))));
    return (new MailMessage)
      ->subject("Welcome to {$siteName}!")
      ->greeting('Hello ' . $this->shop->name . '!')
      ->line('Thank you for registering. To activate your account, kindly verify your membership subscription payment.')
      ->action('Verify Now', $url)
      ->line('Thank you for using our application!');
  }

  /**
   * Get the array representation of the notification.
   *
   * @param  mixed  $notifiable
   * @return array
   */
  public function toArray($notifiable)
  {
    return [
      //
    ];
  }
}
