<?php

namespace App\Providers;

use App\Models\Product;
use App\Policies\ProductPolicy;
use Illuminate\Foundation\Support\Providers\AuthServiceProvider as ServiceProvider;
use Illuminate\Support\Facades\Gate;
use Laravel\Passport\Passport;

class AuthServiceProvider extends ServiceProvider
{

  protected $policies = [
    // 'App\Model' => 'App\Policies\ModelPolicy',
    Product::class => ProductPolicy::class,
  ];

  public function boot(): void
  {
    // Register policies first
    $this->registerPolicies();

    // Passport routes (keep if you're using Passport)
    Passport::routes();

    // Passport::personalAccessClient();

    // Give "Super Admin" everything (Spatie Permission compatible)
    Gate::before(function ($user, $ability) {
      return $user->hasRole('Super Admin') ? true : null;
    });
  }
}
