<?php

namespace Database\Factories;

use App\Models\Product;
use App\Models\Shop;
use Illuminate\Database\Eloquent\Factories\Factory;

class ProductFactory extends Factory
{
  protected $model = Product::class;

  public function definition(): array
  {
    return [
      'shop_id' => Shop::factory(), // Automatically creates a shop
      'name' => $this->faker->words(3, true),
      'thumbnail_img' => $this->faker->imageUrl(640, 480, 'food'),
      'description' => '<p>' . $this->faker->sentence(12) . '</p>',
      'lowest_price' => 270,
      'highest_price' => 270,
      'sku' => strtoupper($this->faker->bothify('???#######')),
      'discount' => 0,
      'discount_type' => 'flat',
      'stock' => 1,
      'published' => 1,
      'approved' => 1,
      'unit' => '200g (7.05 fl oz)',
      'min_qty' => 1,
      'max_qty' => 0,
      'is_variant' => 0,
      'has_warranty' => 0,
      'standard_delivery_time' => 24,
      'express_delivery_time' => 24,
      'weight' => 0,
      'height' => 0,
      'length' => 0,
      'width' => 0,
      'slug' => $this->faker->slug,
      'rating' => 0,
      'num_of_sale' => 0,
      'earn_point' => 0,
      'digital' => 0,
      'created_at' => now(),
      'updated_at' => now(),
    ];
  }
}
