<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Spatie\Permission\Models\Permission;
use Spatie\Permission\Models\Role;

class ProductPermissionsSeeder extends Seeder
{
  public function run()
  {
    $guard = 'web';

    $perms = [
      'show_products',      // index
      'add_products',       // create/store
      'view_products',      // show
      'edit_products',      // edit/update
      'duplicate_products', // duplicate
      'delete_products',    // destroy
      'publish_products',   // toggle published
    ];

    foreach ($perms as $name) {
      Permission::firstOrCreate(
        ['name' => $name, 'guard_name' => $guard],
        [] // no extra attrs
      );
    }

    // give all product perms to admin/Admin
    if ($admin = Role::whereIn('name', ['admin', 'Admin'])->first()) {
      $admin->givePermissionTo($perms);
    }
  }
}
