<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\Artisan;
use Illuminate\Support\Facades\DB;
use Spatie\Permission\Models\Permission;
use Spatie\Permission\Models\Role;

class RemoveMerchantRoleAndPermissionsSeeder extends Seeder
{
  public function run(): void
  {
    $guard = 'web';

    // 1) Remove merchant role(s)
    $roles = Role::where('guard_name', $guard)
      ->whereIn('name', ['merchant', 'Merchant'])
      ->get();

    foreach ($roles as $role) {
      DB::table('model_has_roles')->where('role_id', $role->id)->delete();
      DB::table('role_has_permissions')->where('role_id', $role->id)->delete();
      $role->delete();
    }

    // 2) Remove merchant-related permissions
    $permNames = [
      'merchant.access',
      'merchant.view_dashboard',
      'merchant.view_products',
      'merchant.view_earnings',
      'merchant.manage_profile',
      'merchant.view_payouts',
      'merchant.request_payout',
      'merchant.payout_settings',
      'merchant_earnings.view_all',
      'merchant_earnings.export',
      'show_merchants',
      'add_merchants',
      'edit_merchants',
      'delete_merchants',
    ];

    foreach ($permNames as $name) {
      $perm = Permission::where('name', $name)
        ->where('guard_name', $guard)
        ->first();

      if (! $perm) {
        continue;
      }

      DB::table('role_has_permissions')->where('permission_id', $perm->id)->delete();
      DB::table('model_has_permissions')->where('permission_id', $perm->id)->delete();
      $perm->delete();
    }

    Artisan::call('permission:cache-reset');
  }
}
