<?php

use Illuminate\Database\Seeder;
use Spatie\Permission\Models\Permission;
use Spatie\Permission\Models\Role;

class MerchantEarningsPermissionsSeeder extends Seeder
{
  public function run()
  {
    Permission::firstOrCreate(['name' => 'merchant_earnings.view_all', 'guard_name' => 'web']);
    Permission::firstOrCreate(['name' => 'merchant_earnings.export',   'guard_name' => 'web']);

    if ($admin = Role::whereIn('name', ['admin', 'Admin'])->first()) {
      $admin->givePermissionTo(['merchant_earnings.view_all', 'merchant_earnings.export']);
    }
    if ($staff = Role::whereIn('name', ['staff', 'Staff'])->first()) {
      $staff->givePermissionTo(['merchant_earnings.view_all']);
    }
  }
}
