<?php

use Illuminate\Database\Seeder;
use Spatie\Permission\Models\Permission;
use Spatie\Permission\Models\Role;

class MerchantPortalPermissionsSeeder extends Seeder
{
  public function run()
  {
    // ensure role exists
    $merchantRole = Role::firstOrCreate(['name' => 'Merchant', 'guard_name' => 'web']);

    $perms = [
      ['name' => 'merchant.access',          'parent' => 'merchant', 'guard_name' => 'web'],
      ['name' => 'merchant.view_payouts',    'parent' => 'merchant', 'guard_name' => 'web'],
      ['name' => 'merchant.request_payout',  'parent' => 'merchant', 'guard_name' => 'web'],
      ['name' => 'merchant.payout_settings', 'parent' => 'merchant', 'guard_name' => 'web'],
    ];

    foreach ($perms as $p) {
      Permission::query()->updateOrCreate(
        ['name' => $p['name'], 'guard_name' => $p['guard_name']],
        ['parent' => $p['parent']]
      );
    }

    $merchantRole->givePermissionTo(array_column($perms, 'name'));

    if ($admin = Role::whereIn('name', ['admin', 'Admin'])->first()) {
      $admin->givePermissionTo(array_column($perms, 'name'));
    }
    if ($staff = Role::whereIn('name', ['staff', 'Staff'])->first()) {
      $staff->givePermissionTo(['merchant.view_payouts']);
    }
  }
}
